/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.tasks;

import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.model.PluginInfo;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoadPluginReleaseTask
implements RetryableTask {
    private static final Logger log = LoggerFactory.getLogger(LoadPluginReleaseTask.class);
    private final Front50Service front50Service;

    public LoadPluginReleaseTask(Front50Service front50Service) {
        this.front50Service = front50Service;
    }

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        PluginInfo pluginInfo;
        String pluginId = Objects.requireNonNull((String)stage.getContext().get("pluginId"));
        String version = Objects.requireNonNull((String)stage.getContext().get("version"));
        try {
            pluginInfo = this.front50Service.getPluginInfo(pluginId);
        }
        catch (Exception e) {
            log.error("Failed to retrieve plugin info for '{}'", (Object)pluginId, (Object)e);
            return TaskResult.RUNNING;
        }
        return pluginInfo.getReleases().stream().filter(it -> it.getVersion().equals(version)).findFirst().map(r -> TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).context("release", r).build()).orElse(TaskResult.builder((ExecutionStatus)ExecutionStatus.TERMINAL).output("message", (Object)String.format("No release found for version '%s'", version)).build());
    }

    public long getBackoffPeriod() {
        return Duration.ofSeconds(10L).toMillis();
    }

    public long getTimeout() {
        return Duration.ofMinutes(2L).toMillis();
    }
}

