/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.pipeline;

import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.Trigger;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.pipeline.PipelineValidator;
import com.netflix.spinnaker.orca.pipeline.model.PipelineExecutionImpl;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import retrofit.RetrofitError;

@Component
public class EnabledPipelineValidator
implements PipelineValidator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Front50Service front50Service;

    @Autowired
    public EnabledPipelineValidator(Optional<Front50Service> front50Service) {
        this.front50Service = front50Service.orElse(null);
    }

    public void checkRunnable(PipelineExecution pipeline) {
        if (this.front50Service == null) {
            throw new UnsupportedOperationException("Front50 not enabled, no way to validate pipeline. Fix this by setting front50.enabled: true");
        }
        Boolean isExplicitlyEnabled = ((PipelineExecutionImpl)pipeline).getInitialConfig().getOrDefault("enabled", false);
        if (isExplicitlyEnabled.booleanValue()) {
            return;
        }
        if (!this.isStrategy(pipeline)) {
            try {
                Map<String, Object> pipelineConfig = this.front50Service.getPipeline(pipeline.getPipelineConfigId());
                if (((Boolean)pipelineConfig.getOrDefault("disabled", false)).booleanValue()) {
                    throw new PipelineIsDisabled(pipelineConfig.get("id").toString(), pipelineConfig.get("application").toString(), pipelineConfig.get("name").toString());
                }
                return;
            }
            catch (RetrofitError pipelineConfig) {
                // empty catch block
            }
        }
        List<Map<String, Object>> pipelines = this.isStrategy(pipeline) ? this.front50Service.getStrategies(pipeline.getApplication()) : this.front50Service.getPipelines(pipeline.getApplication(), false);
        pipelines.stream().filter(it -> it.get("id").equals(pipeline.getPipelineConfigId())).findFirst().ifPresent(it -> {
            if (it.getOrDefault("disabled", false).booleanValue()) {
                throw new PipelineIsDisabled(it.get("id").toString(), it.get("application").toString(), it.get("name").toString());
            }
        });
    }

    private boolean isStrategy(PipelineExecution pipeline) {
        Trigger trigger = pipeline.getTrigger();
        return "pipeline".equals(trigger.getType()) && trigger.isStrategy();
    }

    static class PipelineIsDisabled
    extends PipelineValidator.PipelineValidationFailed {
        PipelineIsDisabled(String id, String application, String name) {
            super(String.format("The pipeline config %s (%s) belonging to %s is disabled", name, id, application));
        }
    }
}

