/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.tasks;

import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import retrofit.client.Response;

@Component
public class DeletePluginInfoTask
implements Task {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Front50Service front50Service;

    @Autowired
    public DeletePluginInfoTask(Front50Service front50Service) {
        this.front50Service = front50Service;
    }

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        StageData stageData = (StageData)stage.mapTo(StageData.class);
        if (stageData.pluginInfoId == null) {
            throw new IllegalArgumentException("Key 'pluginInfoId' must be provided.");
        }
        String pluginInfoId = stageData.pluginInfoId;
        this.log.debug("Deleting front50 plugin info `{}`", (Object)pluginInfoId);
        Response response = this.front50Service.deletePluginInfo(pluginInfoId);
        if (response.getStatus() != HttpStatus.NO_CONTENT.value() && response.getStatus() != HttpStatus.NOT_FOUND.value()) {
            this.log.warn("Failed to delete `{}`, received unexpected response status `{}`", (Object)pluginInfoId, (Object)response.getStatus());
            return TaskResult.ofStatus((ExecutionStatus)ExecutionStatus.TERMINAL);
        }
        HashMap<String, Object> outputs = new HashMap<String, Object>();
        outputs.put("front50ResponseStatus", response.getStatus());
        outputs.put("pluginInfoId", pluginInfoId);
        return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).context(outputs).build();
    }

    private static class StageData {
        public String pluginInfoId;

        private StageData() {
        }
    }
}

