/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.tasks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.model.DeliveryConfig;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import retrofit.RetrofitError;

@Component
public class MonitorFront50Task
implements RetryableTask {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Front50Service front50Service;
    private final int successThreshold;
    private final int gracePeriodMs;
    private final ObjectMapper objectMapper;

    @Autowired
    public MonitorFront50Task(Optional<Front50Service> front50Service, ObjectMapper objectMapper, @Value(value="${tasks.monitor-front50-task.success-threshold:0}") int successThreshold, @Value(value="${tasks.monitor-front50-task.grace-period-ms:5000}") int gracePeriodMs) {
        this.front50Service = front50Service.orElse(null);
        this.objectMapper = objectMapper;
        this.successThreshold = successThreshold;
        this.gracePeriodMs = gracePeriodMs;
    }

    public long getBackoffPeriod() {
        return TimeUnit.SECONDS.toMillis(5L);
    }

    public long getTimeout() {
        return TimeUnit.SECONDS.toMillis(90L);
    }

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        if (this.front50Service == null) {
            throw new UnsupportedOperationException("Front50 was not enabled. Fix this by setting front50.enabled: true");
        }
        if (this.successThreshold == 0) {
            return TaskResult.SUCCEEDED;
        }
        StageData stageData = (StageData)stage.mapTo(StageData.class);
        if (stageData.pipelineId != null) {
            try {
                return this.monitor(this::getPipeline, stageData.pipelineId, stage.getStartTime());
            }
            catch (Exception e) {
                this.log.error("Unable to verify that pipeline has been updated (executionId: {}, pipeline: {})", new Object[]{stage.getExecution().getId(), stageData.pipelineName, e});
                return TaskResult.RUNNING;
            }
        }
        if (stageData.deliveryConfig != null) {
            String deliveryConfigId = stageData.deliveryConfig.getId();
            try {
                return this.monitor(this::getDeliveryConfig, deliveryConfigId, stage.getStartTime());
            }
            catch (Exception e) {
                this.log.error("Unable to verify that delivery config has been updated (executionId: {}, configId: {})", new Object[]{stage.getExecution().getId(), deliveryConfigId, e});
                return TaskResult.RUNNING;
            }
        }
        this.log.warn("No id found, unable to verify that the object has been updated (executionId: {})", (Object)stage.getExecution().getId());
        return TaskResult.SUCCEEDED;
    }

    private TaskResult monitor(Function<String, Optional<Map<String, Object>>> getObjectFunction, String id, Long startTime) {
        for (int i = 0; i < this.successThreshold; ++i) {
            Optional<Map<String, Object>> object = getObjectFunction.apply(id);
            if (!object.isPresent()) {
                return TaskResult.RUNNING;
            }
            Long lastModifiedTime = object.get().containsKey("updateTs") ? Long.valueOf(object.get().get("updateTs").toString()) : Long.valueOf(object.get().get("lastModified").toString());
            if (lastModifiedTime < startTime - (long)this.gracePeriodMs) {
                return TaskResult.RUNNING;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return TaskResult.SUCCEEDED;
    }

    private Optional<Map<String, Object>> getPipeline(String id) {
        try {
            return Optional.of(this.front50Service.getPipeline(id));
        }
        catch (RetrofitError e) {
            if (e.getResponse() != null && e.getResponse().getStatus() == 404) {
                return Optional.empty();
            }
            throw e;
        }
    }

    private Optional<Map<String, Object>> getDeliveryConfig(String id) {
        try {
            DeliveryConfig deliveryConfig = this.front50Service.getDeliveryConfig(id);
            return Optional.of((Map)this.objectMapper.convertValue((Object)deliveryConfig, Map.class));
        }
        catch (RetrofitError e) {
            if (e.getResponse() != null && Arrays.asList(404, 403, 401).contains(e.getResponse().getStatus())) {
                return Optional.empty();
            }
            throw e;
        }
    }

    private static class StageData {
        public String application;
        @JsonProperty(value="pipeline.id")
        public String pipelineId;
        @JsonProperty(value="pipeline.name")
        public String pipelineName;
        public DeliveryConfig deliveryConfig;

        private StageData() {
        }
    }
}

