/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.tasks;

import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SetPreferredPluginReleaseTask
implements RetryableTask {
    private static final Logger log = LoggerFactory.getLogger(SetPreferredPluginReleaseTask.class);
    private final Front50Service front50Service;

    public SetPreferredPluginReleaseTask(Front50Service front50Service) {
        this.front50Service = front50Service;
    }

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        String pluginId = (String)stage.getContext().get("pluginId");
        String version = (String)stage.getContext().get("preferredVersion");
        Objects.requireNonNull(pluginId, "pluginId must be provided");
        Objects.requireNonNull(version, "preferredVersion must be provided");
        try {
            this.front50Service.setPreferredPluginVersion(pluginId, version, true);
        }
        catch (Exception e) {
            log.error("Failed setting preferred plugin version '{}' to '{}'", new Object[]{pluginId, version, e});
            return TaskResult.RUNNING;
        }
        return TaskResult.SUCCEEDED;
    }

    public long getBackoffPeriod() {
        return Duration.ofSeconds(10L).toMillis();
    }

    public long getTimeout() {
        return Duration.ofMinutes(2L).toMillis();
    }
}

