/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jakewharton.retrofit.Ok3Client;
import com.netflix.spinnaker.config.DefaultServiceEndpoint;
import com.netflix.spinnaker.config.ServiceEndpoint;
import com.netflix.spinnaker.config.okhttp3.OkHttpClientProvider;
import com.netflix.spinnaker.orca.events.ExecutionEvent;
import com.netflix.spinnaker.orca.events.ExecutionListenerAdapter;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.spring.DependentPipelineExecutionListener;
import com.netflix.spinnaker.orca.listeners.ExecutionListener;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.retrofit.RetrofitConfiguration;
import com.netflix.spinnaker.orca.retrofit.logging.RetrofitSlf4jLog;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import retrofit.Endpoint;
import retrofit.Endpoints;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.JacksonConverter;

@Configuration
@Import(value={RetrofitConfiguration.class})
@ComponentScan(value={"com.netflix.spinnaker.orca.front50.pipeline", "com.netflix.spinnaker.orca.front50.tasks", "com.netflix.spinnaker.orca.front50"})
@ConditionalOnExpression(value="${front50.enabled:true}")
public class Front50Configuration
implements GroovyObject {
    @Autowired
    private OkHttpClientProvider clientProvider;
    @Autowired
    private RestAdapter.LogLevel retrofitLogLevel;
    @Autowired
    private RequestInterceptor spinnakerRequestInterceptor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public Front50Configuration() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Bean
    public Endpoint front50Endpoint(@Value(value="${front50.base-url}") String front50BaseUrl) {
        return Endpoints.newFixedEndpoint((String)front50BaseUrl);
    }

    @Bean
    public Front50Service front50Service(Endpoint front50Endpoint, ObjectMapper mapper) {
        return (Front50Service)ScriptBytecodeAdapter.castToType((Object)new RestAdapter.Builder().setRequestInterceptor(this.spinnakerRequestInterceptor).setEndpoint(front50Endpoint).setClient((Client)new Ok3Client(this.clientProvider.getClient((ServiceEndpoint)new DefaultServiceEndpoint("front50", front50Endpoint.getUrl())))).setLogLevel(this.retrofitLogLevel).setLog((RestAdapter.Log)new RetrofitSlf4jLog(Front50Service.class)).setConverter((Converter)new JacksonConverter(mapper)).build().create(Front50Service.class), Front50Service.class);
    }

    @Bean
    public ApplicationListener<ExecutionEvent> dependentPipelineExecutionListenerAdapter(DependentPipelineExecutionListener delegate, ExecutionRepository repository) {
        return new ExecutionListenerAdapter((ExecutionListener)delegate, repository);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Front50Configuration.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public OkHttpClientProvider getClientProvider() {
        return this.clientProvider;
    }

    @Generated
    public void setClientProvider(OkHttpClientProvider okHttpClientProvider) {
        this.clientProvider = okHttpClientProvider;
    }

    @Generated
    public RestAdapter.LogLevel getRetrofitLogLevel() {
        return this.retrofitLogLevel;
    }

    @Generated
    public void setRetrofitLogLevel(RestAdapter.LogLevel logLevel) {
        this.retrofitLogLevel = logLevel;
    }

    @Generated
    public RequestInterceptor getSpinnakerRequestInterceptor() {
        return this.spinnakerRequestInterceptor;
    }

    @Generated
    public void setSpinnakerRequestInterceptor(RequestInterceptor requestInterceptor) {
        this.spinnakerRequestInterceptor = requestInterceptor;
    }
}

