/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.clouddriver.utils.CloudProviderAware;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.PipelineModelMutator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import retrofit.client.Response;

@Component
public class DeletePipelineTask
implements CloudProviderAware,
RetryableTask {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final Front50Service front50Service;
    private final List<PipelineModelMutator> pipelineModelMutators;
    ObjectMapper objectMapper;

    @Autowired
    DeletePipelineTask(Optional<Front50Service> front50Service, Optional<List<PipelineModelMutator>> pipelineModelMutators, ObjectMapper objectMapper) {
        this.front50Service = front50Service.orElse(null);
        this.pipelineModelMutators = pipelineModelMutators.orElse(new ArrayList());
        this.objectMapper = objectMapper;
    }

    public TaskResult execute(StageExecution stage) {
        HashMap<String, String> outputs;
        Response response;
        Boolean isSavingMultiplePipelines;
        block7: {
            String serviceAccount;
            Map<String, Object> existingPipeline;
            if (this.front50Service == null) {
                throw new UnsupportedOperationException("Front50 is not enabled, no way to delete pipeline. Fix this by setting front50.enabled: true");
            }
            if (!stage.getContext().containsKey("pipeline")) {
                throw new IllegalArgumentException("pipeline context must be provided");
            }
            Map pipeline = !(stage.getContext().get("pipeline") instanceof String) ? (Map)stage.getContext().get("pipeline") : (Map)stage.decodeBase64("/pipeline", Map.class);
            if (!pipeline.containsKey("index") && (existingPipeline = this.fetchExistingPipeline(pipeline)) != null) {
                pipeline.put("index", existingPipeline.get("index"));
            }
            if ((serviceAccount = (String)stage.getContext().get("pipeline.serviceAccount")) != null) {
                this.updateServiceAccount(pipeline, serviceAccount);
            }
            isSavingMultiplePipelines = Optional.ofNullable(stage.getContext().get("isSavingMultiplePipelines")).orElse(false);
            Boolean staleCheck = Optional.ofNullable(stage.getContext().get("staleCheck")).orElse(false);
            if (stage.getContext().get("pipeline.id") != null && pipeline.get("id") == null && !isSavingMultiplePipelines.booleanValue()) {
                pipeline.put("id", stage.getContext().get("pipeline.id"));
                pipeline.put("regenerateCronTriggerIds", true);
            }
            this.pipelineModelMutators.stream().filter(m -> m.supports(pipeline)).forEach(m -> m.mutate(pipeline));
            response = this.front50Service.deletePipeline(pipeline.get("application").toString(), pipeline.get("name").toString());
            outputs = new HashMap<String, String>();
            outputs.put("notification.type", "deletepipeline");
            outputs.put("application", (String)pipeline.get("application"));
            outputs.put("pipeline.name", (String)pipeline.get("name"));
            try {
                Map savedPipeline = (Map)this.objectMapper.readValue(response.getBody().in(), Map.class);
                outputs.put("pipeline.id", (String)savedPipeline.get("id"));
            }
            catch (Exception e) {
                this.log.error("Unable to deserialize saved pipeline, reason: ", (Throwable)e);
                if (!pipeline.containsKey("id")) break block7;
                outputs.put("pipeline.id", (String)pipeline.get("id"));
            }
        }
        ExecutionStatus status = response.getStatus() == HttpStatus.OK.value() ? ExecutionStatus.SUCCEEDED : (isSavingMultiplePipelines != false ? ExecutionStatus.FAILED_CONTINUE : ExecutionStatus.TERMINAL);
        return TaskResult.builder((ExecutionStatus)status).context(outputs).build();
    }

    public long getBackoffPeriod() {
        return 1000L;
    }

    public long getTimeout() {
        return TimeUnit.SECONDS.toMillis(30L);
    }

    private void updateServiceAccount(Map<String, Object> pipeline, String serviceAccount) {
        if (StringUtils.isEmpty((CharSequence)serviceAccount) || !pipeline.containsKey("triggers")) {
            return;
        }
        List triggers = (List)pipeline.get("triggers");
        List roles = (List)pipeline.get("roles");
        if (roles == null || roles.isEmpty()) {
            triggers.forEach(t -> t.remove("runAsUser", serviceAccount));
            return;
        }
    }

    private Map<String, Object> fetchExistingPipeline(Map<String, Object> newPipeline) {
        String applicationName = (String)newPipeline.get("application");
        String newPipelineID = (String)newPipeline.get("id");
        if (!StringUtils.isEmpty((CharSequence)newPipelineID)) {
            return this.front50Service.getPipelines(applicationName).stream().filter(m -> m.containsKey("id")).filter(m -> m.get("id").equals(newPipelineID)).findFirst().orElse(null);
        }
        return null;
    }
}

