/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.tasks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.model.DeliveryConfig;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import retrofit.RetrofitError;

@Component
public class DeleteDeliveryConfigTask
implements Task {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Front50Service front50Service;
    private ObjectMapper objectMapper;

    @Autowired
    public DeleteDeliveryConfigTask(Front50Service front50Service, ObjectMapper objectMapper) {
        this.front50Service = front50Service;
        this.objectMapper = objectMapper;
    }

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        StageData stageData = (StageData)stage.mapTo(StageData.class);
        if (stageData.deliveryConfigId == null) {
            throw new IllegalArgumentException("Key 'deliveryConfigId' must be provided.");
        }
        Optional<DeliveryConfig> config = this.getDeliveryConfig(stageData.deliveryConfigId);
        if (!config.isPresent()) {
            this.log.debug("Config {} does not exist, considering deletion successful.", (Object)stageData.deliveryConfigId);
            return TaskResult.SUCCEEDED;
        }
        try {
            this.log.debug("Deleting delivery config: " + this.objectMapper.writeValueAsString((Object)config.get()));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        this.front50Service.deleteDeliveryConfig(config.get().getApplication(), stageData.deliveryConfigId);
        return TaskResult.SUCCEEDED;
    }

    public Optional<DeliveryConfig> getDeliveryConfig(String id) {
        try {
            DeliveryConfig deliveryConfig = this.front50Service.getDeliveryConfig(id);
            return Optional.of(deliveryConfig);
        }
        catch (RetrofitError e) {
            if (e.getResponse() != null && Arrays.asList(404, 403, 401).contains(e.getResponse().getStatus())) {
                return Optional.empty();
            }
            throw e;
        }
    }

    private static class StageData {
        public String deliveryConfigId;

        private StageData() {
        }
    }
}

