/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.tasks;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.model.PluginInfo;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpsertPluginInfoTask
implements Task {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Front50Service front50Service;
    private ObjectMapper objectMapper;

    @Autowired
    public UpsertPluginInfoTask(Front50Service front50Service, ObjectMapper objectMapper) {
        this.front50Service = front50Service;
        this.objectMapper = objectMapper;
    }

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        if (!stage.getContext().containsKey("pluginInfo")) {
            throw new IllegalArgumentException("Key 'pluginInfo' must be provided.");
        }
        PluginInfo pluginInfo = (PluginInfo)this.objectMapper.convertValue(stage.getContext().get("pluginInfo"), (TypeReference)new TypeReference<PluginInfo>(){});
        this.log.debug("Upserting front50 plugin info `{}`", (Object)pluginInfo.getId());
        PluginInfo upsertedPluginInfo = this.front50Service.upsertPluginInfo(pluginInfo);
        HashMap<String, PluginInfo> outputs = new HashMap<String, PluginInfo>();
        outputs.put("pluginInfo", upsertedPluginInfo);
        return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).context(outputs).build();
    }
}

