/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.tasks;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.netflix.spinnaker.fiat.model.UserPermission;
import com.netflix.spinnaker.fiat.model.resources.Role;
import com.netflix.spinnaker.fiat.model.resources.ServiceAccount;
import com.netflix.spinnaker.fiat.shared.FiatPermissionEvaluator;
import com.netflix.spinnaker.fiat.shared.FiatStatus;
import com.netflix.spinnaker.kork.exceptions.UserException;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import retrofit.client.Response;

@Component
public class SaveServiceAccountTask
implements RetryableTask {
    private static final Logger log = LoggerFactory.getLogger(SaveServiceAccountTask.class);
    private final FiatStatus fiatStatus;
    private final Front50Service front50Service;
    private final FiatPermissionEvaluator fiatPermissionEvaluator;
    private final boolean useSharedManagedServiceAccounts;

    @Autowired
    SaveServiceAccountTask(Optional<FiatStatus> fiatStatus, Optional<Front50Service> front50Service, Optional<FiatPermissionEvaluator> fiatPermissionEvaluator, @Value(value="${tasks.use-shared-managed-service-accounts:false}") boolean useSharedManagedServiceAccounts) {
        this.fiatStatus = fiatStatus.get();
        this.front50Service = front50Service.get();
        this.fiatPermissionEvaluator = fiatPermissionEvaluator.get();
        this.useSharedManagedServiceAccounts = useSharedManagedServiceAccounts;
    }

    public long getBackoffPeriod() {
        return TimeUnit.SECONDS.toMillis(1L);
    }

    public long getTimeout() {
        return TimeUnit.SECONDS.toMillis(60L);
    }

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        Map pipeline;
        if (!this.fiatStatus.isEnabled()) {
            throw new UnsupportedOperationException("Fiat is not enabled, cannot save roles.");
        }
        if (this.front50Service == null) {
            throw new UnsupportedOperationException("Front50 is not enabled, no way to save pipeline. Fix this by setting front50.enabled: true");
        }
        if (!stage.getContext().containsKey("pipeline")) {
            throw new IllegalArgumentException("pipeline context must be provided");
        }
        if (!(stage.getContext().get("pipeline") instanceof String)) {
            throw new IllegalArgumentException("'pipeline' context key must be a base64-encoded string: Ensure you're on the most recent version of gate");
        }
        try {
            pipeline = (Map)stage.decodeBase64("/pipeline", Map.class);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("pipeline must be encoded as base64", e);
        }
        if (!pipeline.containsKey("roles")) {
            log.debug("Skipping managed service accounts since roles field is not present.");
            return TaskResult.SUCCEEDED;
        }
        List roles = (List)pipeline.get("roles");
        String user = stage.getExecution().getTrigger().getUser();
        HashMap<String, String> outputs = new HashMap<String, String>();
        pipeline.computeIfAbsent("id", k -> {
            String uuid = UUID.randomUUID().toString();
            outputs.put("pipeline.id", uuid);
            return uuid;
        });
        String serviceAccountName = this.generateSvcAcctName(pipeline, roles);
        if (!this.pipelineRolesChanged(serviceAccountName, roles)) {
            log.debug("Skipping managed service account creation/updatimg since roles have not changed.");
            return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).context((Map)ImmutableMap.of((Object)"pipeline.serviceAccount", (Object)serviceAccountName)).build();
        }
        if (!this.isUserAuthorized(user, roles)) {
            log.warn("User {} is not authorized with all roles for pipeline", (Object)user);
            throw new UserException(String.format("User '%s' is not authorized with all roles for pipeline", user));
        }
        ServiceAccount svcAcct = new ServiceAccount();
        svcAcct.setName(serviceAccountName);
        svcAcct.setMemberOf(roles);
        Response response = this.front50Service.saveServiceAccount(svcAcct);
        if (response.getStatus() != HttpStatus.OK.value()) {
            return TaskResult.ofStatus((ExecutionStatus)ExecutionStatus.TERMINAL);
        }
        outputs.put("pipeline.serviceAccount", svcAcct.getName());
        return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).context(outputs).build();
    }

    private String generateSvcAcctName(Map<String, Object> pipeline, List<String> roles) {
        if (pipeline.containsKey("serviceAccount")) {
            String serviceAccountName = (String)pipeline.get("serviceAccount");
            if (this.useSharedManagedServiceAccounts || !this.usingSharedManagedServiceAccount(serviceAccountName)) {
                return serviceAccountName;
            }
        }
        if (this.useSharedManagedServiceAccounts) {
            return this.generateStableSvcAcctNameFromRoles(roles) + "@shared-managed-service-account";
        }
        String pipelineName = (String)pipeline.get("id");
        return pipelineName.toLowerCase() + "@managed-service-account";
    }

    private boolean usingSharedManagedServiceAccount(String serviceAccountName) {
        return serviceAccountName.endsWith("@shared-managed-service-account");
    }

    private String generateStableSvcAcctNameFromRoles(List<String> roles) {
        String roleString = roles.stream().map(String::toLowerCase).distinct().sorted().collect(Collectors.joining("\u0000"));
        return Hashing.sha256().hashString((CharSequence)roleString, StandardCharsets.UTF_8).toString();
    }

    private boolean isUserAuthorized(String user, List<String> pipelineRoles) {
        if (user == null) {
            return false;
        }
        if (pipelineRoles == null || pipelineRoles.isEmpty()) {
            return true;
        }
        UserPermission.View permission = this.fiatPermissionEvaluator.getPermission(user);
        if (permission == null) {
            return false;
        }
        if (permission.isAdmin()) {
            return true;
        }
        Set userRoles = permission.getRoles().stream().map(Role.View::getName).collect(Collectors.toSet());
        return userRoles.containsAll(pipelineRoles);
    }

    private boolean pipelineRolesChanged(String serviceAccountName, List<String> pipelineRoles) {
        UserPermission.View permission = this.fiatPermissionEvaluator.getPermission(serviceAccountName);
        if (permission == null || pipelineRoles == null) {
            return true;
        }
        Set currentRoles = permission.getRoles().stream().map(Role.View::getName).collect(Collectors.toSet());
        return !currentRoles.equals(new HashSet<String>(pipelineRoles));
    }
}

