/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.pipeline;

import com.netflix.spinnaker.orca.api.pipeline.CancellableStage;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageGraphBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.TaskNode;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.tasks.MonitorPipelineTask;
import com.netflix.spinnaker.orca.front50.tasks.StartPipelineTask;
import com.netflix.spinnaker.orca.pipeline.model.StageContext;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.tasks.artifacts.BindProducedArtifactsTask;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PipelineStage
implements StageDefinitionBuilder,
CancellableStage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Value(value="${stages.pipeline.defaultSkipDownstreamOutput:false}")
    private boolean defaultSkipDownstreamOutput;
    public static final String PIPELINE_CONFIG_TYPE = StageDefinitionBuilder.getType(PipelineStage.class);
    final ExecutionRepository executionRepository;

    @Autowired
    public PipelineStage(ExecutionRepository executionRepository) {
        this.executionRepository = executionRepository;
    }

    public void taskGraph(@Nonnull StageExecution stage, @Nonnull TaskNode.Builder builder) {
        if (stage.getContext().get("executionId") == null) {
            builder.withTask("startPipeline", StartPipelineTask.class);
        }
        if (!stage.getContext().getOrDefault("waitForCompletion", "true").toString().toLowerCase().equals("false")) {
            builder.withTask("monitorPipeline", MonitorPipelineTask.class);
        }
        if (stage.getContext().containsKey("expectedArtifacts")) {
            builder.withTask("bindProducedArtifacts", BindProducedArtifactsTask.class);
        }
    }

    public void afterStages(@Nonnull StageExecution stage, @Nonnull StageGraphBuilder graph) {
        if (this.shouldSkipDownstreamOutput(stage)) {
            stage.setOutputs(Collections.emptyMap());
        }
    }

    public void prepareStageForRestart(@Nonnull StageExecution stage) {
        StageContext context = (StageContext)stage.getContext();
        context.remove((Object)"status");
        boolean skipPipelineRestart = (Boolean)context.getCurrentOnly((Object)"_skipPipelineRestart", (Object)false);
        if (!skipPipelineRestart) {
            stage.getContext().remove("executionName");
            stage.getContext().remove("executionId");
        } else {
            stage.getContext().remove("_skipPipelineRestart");
        }
    }

    public CancellableStage.Result cancel(StageExecution stage) {
        String readableStageDetails = String.format("(stageId: %s, executionId: %s, context: %s)", stage.getId(), stage.getExecution().getId(), stage.getContext());
        this.log.info(String.format("Cancelling stage %s", readableStageDetails));
        try {
            String executionId = (String)stage.getContext().get("executionId");
            if (executionId != null) {
                if (this.executionRepository == null) {
                    this.log.error(String.format("Stage %s could not be canceled w/o front50 enabled. Please set 'front50.enabled: true' in your orca config.", readableStageDetails));
                } else {
                    PipelineExecution childPipeline = this.executionRepository.retrieve(ExecutionType.PIPELINE, executionId);
                    if (!childPipeline.isCanceled()) {
                        this.executionRepository.cancel(stage.getExecution().getType(), executionId, "parent pipeline", null);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error(String.format("Failed to cancel stage %s, e: %s", readableStageDetails, e.getMessage()), (Throwable)e);
        }
        return new CancellableStage.Result(stage, Collections.emptyMap());
    }

    public boolean canManuallySkip(StageExecution stage) {
        return stage.getContext().getOrDefault("skippable", false);
    }

    private boolean shouldSkipDownstreamOutput(StageExecution stage) {
        return ((Object)stage.getContext().getOrDefault("skipDownstreamOutput", this.defaultSkipDownstreamOutput)).toString().equals("true");
    }
}

