/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.pipeline;

import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.TaskNode;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.tasks.MonitorFront50Task;
import com.netflix.spinnaker.orca.front50.tasks.SavePipelineTask;
import com.netflix.spinnaker.orca.front50.tasks.SaveServiceAccountTask;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SavePipelineStage
implements StageDefinitionBuilder {
    public static final String SERVICE_ACCOUNT_SUFFIX = "@managed-service-account";
    public static final String SHARED_SERVICE_ACCOUNT_SUFFIX = "@shared-managed-service-account";
    @Value(value="${tasks.use-managed-service-accounts:false}")
    boolean useManagedServiceAccounts;

    public void taskGraph(@Nonnull StageExecution stage, @Nonnull TaskNode.Builder builder) {
        if (this.useManagedServiceAccounts) {
            builder.withTask("updatePipelinePermissions", SaveServiceAccountTask.class);
        }
        builder.withTask("savePipeline", SavePipelineTask.class).withTask("waitForPipelineSave", MonitorFront50Task.class);
    }
}

