/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.tasks;

import com.netflix.spinnaker.kork.plugins.CanonicalPluginId;
import com.netflix.spinnaker.kork.plugins.VersionRequirementsParser;
import com.netflix.spinnaker.orca.api.pipeline.Task;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.model.PluginInfo;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ExtractRequiredPluginDependenciesTask
implements Task {
    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        PluginInfo.Release release = (PluginInfo.Release)stage.mapTo("/release", PluginInfo.Release.class);
        ArrayList services = new ArrayList();
        ArrayList plugins = new ArrayList();
        VersionRequirementsParser.INSTANCE.parseAll(release.getRequires()).forEach(requirements -> {
            if (ExtractRequiredPluginDependenciesTask.isServiceRequirement(requirements)) {
                services.add(requirements.getService());
            } else {
                plugins.add(requirements.getService());
            }
        });
        HashMap outputs = new HashMap();
        outputs.put("requiredServices", services);
        outputs.put("requiredPlugins", plugins);
        services.forEach(service -> outputs.put(String.format("requires%s", StringUtils.capitalize((String)service)), true));
        return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).outputs(outputs).build();
    }

    private static boolean isServiceRequirement(VersionRequirementsParser.VersionRequirements requirements) {
        return !CanonicalPluginId.Companion.isValid(requirements.getService());
    }
}

