/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.OverridableTimeoutRetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.pipeline.MonitorPipelineStage;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MonitorPipelineTask
implements OverridableTimeoutRetryableTask,
GroovyObject {
    private ExecutionRepository executionRepository;
    private ObjectMapper objectMapper;
    private long backoffPeriod;
    @Value(value="${tasks.monitor-pipeline.timeout-millis:43200000}")
    private long timeout;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public MonitorPipelineTask(ExecutionRepository executionRepository, ObjectMapper objectMapper) {
        ObjectMapper objectMapper2;
        ExecutionRepository executionRepository2;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("invoke", "toMillis", 0, IndyInterface.bootstrap("getProperty", "SECONDS", 0, TimeUnit.class), 15);
        this.backoffPeriod = DefaultTypeTransformation.longUnbox((Object)callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.executionRepository = executionRepository2 = executionRepository;
        this.objectMapper = objectMapper2 = objectMapper;
    }

    public TaskResult execute(StageExecution stage) {
        CallSite pipelineIds = null;
        boolean isLegacyStage = false;
        CallSite stageData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "mapTo", 0, stage, MonitorPipelineStage.StageParameters.class));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, stage), (Object)IndyInterface.bootstrap("getProperty", "PIPELINE_CONFIG_TYPE", 0, MonitorPipelineStage.class))) {
            pipelineIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "executionIds", 0, stageData)) != false ? IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("getProperty", "executionIds", 0, stageData), null) : IndyInterface.bootstrap("invoke", "emptyList", 0, Collections.class));
        } else {
            pipelineIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "executionId", 0, stageData)) != false ? IndyInterface.bootstrap("invoke", "singletonList", 0, Collections.class, IndyInterface.bootstrap("getProperty", "executionId", 0, stageData)) : IndyInterface.bootstrap("invoke", "emptyList", 0, Collections.class));
            isLegacyStage = true;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, pipelineIds), (Object)0)) {
            String message = "no pipeline execution ids to monitor";
            IndyInterface.bootstrap("invoke", "info", 0, log, message);
            IndyInterface.bootstrap("invoke", "appendErrorMessage", 0, stage, message);
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ofStatus", 0, TaskResult.class, IndyInterface.bootstrap("getProperty", "TERMINAL", 0, ExecutionStatus.class)));
        }
        Reference pipelineStatuses = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class, IndyInterface.bootstrap("invoke", "size", 0, pipelineIds))));
        Reference firstPipeline = new Reference(null);
        PipelineExecution cfr_ignored_0 = (PipelineExecution)firstPipeline.get();
        public final class _execute_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference firstPipeline;
            private /* synthetic */ Reference pipelineStatuses;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _execute_closure1(Object _outerInstance, Object _thisObject, Reference firstPipeline, Reference pipelineStatuses) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.firstPipeline = reference2 = firstPipeline;
                this.pipelineStatuses = reference = pipelineStatuses;
            }

            public Object doCall(Object pipelineId) {
                Reference childPipeline = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "retrieve", 0, IndyInterface.bootstrap("getProperty", "executionRepository", 12, this), IndyInterface.bootstrap("getProperty", "PIPELINE", 0, ExecutionType.class), pipelineId)));
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.firstPipeline.get()), null)) {
                    PipelineExecution pipelineExecution = (PipelineExecution)childPipeline.get();
                    this.firstPipeline.set((Object)pipelineExecution);
                }
                CallSite details = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, MonitorPipelineStage.ChildPipelineStatusDetails.class));
                CallSite callSite = IndyInterface.bootstrap("getProperty", "status", 0, (PipelineExecution)childPipeline.get());
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)details, (String)"status");
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "application", 0, (PipelineExecution)childPipeline.get());
                ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)details, (String)"application");
                IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("cast", "()", 0, this.pipelineStatuses.get()), pipelineId, details);
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "halt", 0, IndyInterface.bootstrap("getProperty", "status", 0, (PipelineExecution)childPipeline.get()))) != false) {
                    CallSite callSite3 = IndyInterface.bootstrap("init", "<init>", 0, MonitorPipelineStage.ChildPipelineException.class);
                    ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)details, (String)"exception");
                    public final class _closure5
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure5(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object s) {
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "status", 0, s), (Object)IndyInterface.bootstrap("getProperty", "TERMINAL", 0, ExecutionStatus.class));
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure5.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite terminalStages = IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("getProperty", "stages", 0, (PipelineExecution)childPipeline.get()), new _closure5((Object)this, this.getThisObject()));
                    public final class _closure6
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference childPipeline;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure6(Object _outerInstance, Object _thisObject, Reference childPipeline) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.childPipeline = reference = childPipeline;
                        }

                        public Object doCall(Object s) {
                            Reference s2 = new Reference(s);
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "details", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "context", 0, s2.get()), "exception"))) != false) {
                                CallSite callSite = IndyInterface.bootstrap("getProperty", "errors", 0, IndyInterface.bootstrap("getProperty", "details", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "context", 0, s2.get()), "exception")));
                                public final class _closure8
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference childPipeline;
                                    private /* synthetic */ Reference s;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure8(Object _outerInstance, Object _thisObject, Reference childPipeline, Reference s) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        Reference reference2;
                                        this.childPipeline = reference2 = childPipeline;
                                        this.s = reference = s;
                                    }

                                    public Object doCall(Object e) {
                                        return IndyInterface.bootstrap("invoke", "buildExceptionMessage", 2, this, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.childPipeline.get())), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, e, String.class))), String.class), this.s.get());
                                    }

                                    @Generated
                                    public PipelineExecution getChildPipeline() {
                                        return IndyInterface.bootstrap("cast", "()", 0, this.childPipeline.get());
                                    }

                                    @Generated
                                    public Object getS() {
                                        return this.s.get();
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure8.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                        return MethodHandles.lookup();
                                    }
                                }
                                return IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "flatten", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : IndyInterface.bootstrap("getProperty", "error", 0, IndyInterface.bootstrap("getProperty", "details", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "context", 0, s2.get()), "exception")))})), new _closure8((Object)this, this.getThisObject(), this.childPipeline, s2));
                            }
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "context", 0, s2.get()), "kato.tasks")) != false) {
                                public final class _closure9
                                extends Closure
                                implements GeneratedClosure {
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure9(Object _outerInstance, Object _thisObject) {
                                        super(_outerInstance, _thisObject);
                                    }

                                    public Object doCall(Object k) {
                                        return IndyInterface.bootstrap("getProperty", "failed", 1, IndyInterface.bootstrap("getProperty", "status", 0, k));
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure9.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                        return MethodHandles.lookup();
                                    }
                                }
                                public final class _closure10
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference childPipeline;
                                    private /* synthetic */ Reference s;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure10(Object _outerInstance, Object _thisObject, Reference childPipeline, Reference s) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        Reference reference2;
                                        this.childPipeline = reference2 = childPipeline;
                                        this.s = reference = s;
                                    }

                                    public Object doCall(Object k) {
                                        CallSite callSite = IndyInterface.bootstrap("getProperty", "message", 1, IndyInterface.bootstrap("getProperty", "exception", 0, k));
                                        CallSite message = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "history", 0, k)) != false ? IndyInterface.bootstrap("invoke", "last", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "history", 0, k))) : null));
                                        return IndyInterface.bootstrap("cast", "()", 0, message) != false ? IndyInterface.bootstrap("invoke", "buildExceptionMessage", 2, this, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.childPipeline.get())), message, this.s.get()) : null;
                                    }

                                    @Generated
                                    public PipelineExecution getChildPipeline() {
                                        return IndyInterface.bootstrap("cast", "()", 0, this.childPipeline.get());
                                    }

                                    @Generated
                                    public Object getS() {
                                        return this.s.get();
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure10.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                        return MethodHandles.lookup();
                                    }
                                }
                                return IndyInterface.bootstrap("invoke", "findResults", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "context", 0, s2.get()), "kato.tasks"), new _closure9((Object)this, this.getThisObject())), new _closure10((Object)this, this.getThisObject(), this.childPipeline, s2));
                            }
                            return null;
                        }

                        @Generated
                        public PipelineExecution getChildPipeline() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.childPipeline.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure6.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite errors = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("invoke", "findResults", 0, terminalStages, new _closure6((Object)this, this.getThisObject(), childPipeline))));
                    CallSite callSite4 = errors;
                    ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)IndyInterface.bootstrap("getProperty", "details", 0, IndyInterface.bootstrap("getProperty", "exception", 0, details)), (String)"errors");
                    public final class _closure7
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure7(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("getProperty", "halt", 0, IndyInterface.bootstrap("getProperty", "status", 0, it));
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure7.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite haltingStage = IndyInterface.bootstrap("invoke", "find", 0, terminalStages, new _closure7((Object)this, this.getThisObject()));
                    if (IndyInterface.bootstrap("cast", "()", 0, haltingStage) != false) {
                        CallSite callSite5 = IndyInterface.bootstrap("getProperty", "id", 0, (PipelineExecution)childPipeline.get());
                        ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)IndyInterface.bootstrap("getProperty", "source", 0, IndyInterface.bootstrap("getProperty", "exception", 0, details)), (String)"executionId");
                        CallSite callSite6 = IndyInterface.bootstrap("getProperty", "id", 0, haltingStage);
                        ScriptBytecodeAdapter.setProperty((Object)callSite6, null, (Object)IndyInterface.bootstrap("getProperty", "source", 0, IndyInterface.bootstrap("getProperty", "exception", 0, details)), (String)"stageId");
                        CallSite callSite7 = IndyInterface.bootstrap("getProperty", "name", 0, haltingStage);
                        ScriptBytecodeAdapter.setProperty((Object)callSite7, null, (Object)IndyInterface.bootstrap("getProperty", "source", 0, IndyInterface.bootstrap("getProperty", "exception", 0, details)), (String)"stageName");
                        CallSite callSite8 = IndyInterface.bootstrap("invoke", "indexOf", 0, IndyInterface.bootstrap("getProperty", "stages", 0, (PipelineExecution)childPipeline.get()), haltingStage);
                        ScriptBytecodeAdapter.setProperty((Object)callSite8, null, (Object)IndyInterface.bootstrap("getProperty", "source", 0, IndyInterface.bootstrap("getProperty", "exception", 0, details)), (String)"stageIndex");
                        return callSite8;
                    }
                }
                return null;
            }

            @Generated
            public PipelineExecution getFirstPipeline() {
                return IndyInterface.bootstrap("cast", "()", 0, this.firstPipeline.get());
            }

            @Generated
            public HashMap getPipelineStatuses() {
                return IndyInterface.bootstrap("cast", "()", 0, this.pipelineStatuses.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _execute_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "forEach", 0, pipelineIds, new _execute_closure1(this, this, firstPipeline, pipelineStatuses));
        public final class _execute_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _execute_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "status", 0, IndyInterface.bootstrap("getProperty", "value", 0, it)), (Object)IndyInterface.bootstrap("getProperty", "SUCCEEDED", 0, ExecutionStatus.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _execute_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        boolean allPipelinesSucceeded = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "every", 0, (HashMap)pipelineStatuses.get(), new _execute_closure2(this, this)));
        public final class _execute_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _execute_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "complete", 0, IndyInterface.bootstrap("getProperty", "status", 0, IndyInterface.bootstrap("getProperty", "value", 0, it)));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _execute_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        boolean allPipelinesCompleted = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "every", 0, (HashMap)pipelineStatuses.get(), new _execute_closure3(this, this)));
        public final class _execute_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _execute_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "effectiveStatus", 2, this, IndyInterface.bootstrap("getProperty", "status", 0, IndyInterface.bootstrap("getProperty", "value", 0, it))), (Object)IndyInterface.bootstrap("getProperty", "TERMINAL", 0, ExecutionStatus.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _execute_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        boolean anyPipelinesFailed = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "any", 0, (HashMap)pipelineStatuses.get(), new _execute_closure4(this, this)));
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, MonitorPipelineStage.StageResult.class));
        CallSite context = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        if (isLegacyStage) {
            IndyInterface.bootstrap("invoke", "put", 0, context, "status", IndyInterface.bootstrap("getProperty", "status", 0, (PipelineExecution)firstPipeline.get()));
            if (anyPipelinesFailed) {
                IndyInterface.bootstrap("invoke", "put", 0, context, "exception", IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, IndyInterface.bootstrap("getProperty", "exception", 0, IndyInterface.bootstrap("invoke", "first", 0, IndyInterface.bootstrap("invoke", "values", 0, (HashMap)pipelineStatuses.get()))), Map.class));
            }
        } else {
            HashMap hashMap = (HashMap)pipelineStatuses.get();
            ScriptBytecodeAdapter.setProperty((Object)hashMap, null, (Object)result, (String)"executionStatuses");
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, pipelineIds), (Object)1) && allPipelinesCompleted) {
            IndyInterface.bootstrap("invoke", "insertPipelineContext", 0, result, IndyInterface.bootstrap("invoke", "getContext", 0, (PipelineExecution)firstPipeline.get()));
        }
        if (allPipelinesSucceeded) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildTaskResult", 2, this, IndyInterface.bootstrap("getProperty", "SUCCEEDED", 0, ExecutionStatus.class), context, result));
        }
        if (anyPipelinesFailed && (allPipelinesCompleted || ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "monitorBehavior", 0, stageData), (Object)IndyInterface.bootstrap("getProperty", "FailFast", 0, MonitorPipelineStage.MonitorBehavior.class)))) {
            IndyInterface.bootstrap("invoke", "appendErrorMessage", 0, stage, "At least one monitored pipeline failed, look for errors in failed pipelines");
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildTaskResult", 2, this, IndyInterface.bootstrap("getProperty", "TERMINAL", 0, ExecutionStatus.class), context, result));
        }
        if (allPipelinesCompleted) {
            IndyInterface.bootstrap("invoke", "appendErrorMessage", 0, stage, "At least one monitored pipeline was cancelled");
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildTaskResult", 2, this, IndyInterface.bootstrap("getProperty", "CANCELED", 0, ExecutionStatus.class), context, result));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildTaskResult", 2, this, IndyInterface.bootstrap("getProperty", "RUNNING", 0, ExecutionStatus.class), context, result));
    }

    private Object buildTaskResult(ExecutionStatus status, Map<String, Object> context, MonitorPipelineStage.StageResult result) {
        return IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "outputs", 0, IndyInterface.bootstrap("invoke", "context", 0, IndyInterface.bootstrap("invoke", "builder", 0, TaskResult.class, status), context), IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, result, Map.class)));
    }

    private static Object effectiveStatus(ExecutionStatus status) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "halt", 0, status)) == false) {
            return status;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)status, (Object)IndyInterface.bootstrap("getProperty", "CANCELED", 0, ExecutionStatus.class))) {
            return IndyInterface.bootstrap("getProperty", "CANCELED", 0, ExecutionStatus.class);
        }
        return IndyInterface.bootstrap("getProperty", "TERMINAL", 0, ExecutionStatus.class);
    }

    private static String buildExceptionMessage(String pipelineName, String message, StageExecution stage) {
        CallSite callSite = IndyInterface.bootstrap("getProperty", "name", 0, stage);
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{pipelineName, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : IndyInterface.bootstrap("getProperty", "type", 0, stage), message}, new String[]{"Exception in child pipeline stage (", ": ", "): ", ""}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MonitorPipelineTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.orca.front50.tasks.MonitorPipelineTask");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public ExecutionRepository getExecutionRepository() {
        return this.executionRepository;
    }

    @Generated
    public void setExecutionRepository(ExecutionRepository executionRepository) {
        this.executionRepository = executionRepository;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Generated
    public long getBackoffPeriod() {
        return this.backoffPeriod;
    }

    @Generated
    public void setBackoffPeriod(long l) {
        this.backoffPeriod = l;
    }

    @Generated
    public long getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setTimeout(long l) {
        this.timeout = l;
    }
}

