/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.pipeline;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.api.expressions.ExpressionFunctionProvider;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.kork.expressions.ExpressionFunctionProvider;
import com.netflix.spinnaker.kork.expressions.SpelHelperFunctionException;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.model.Application;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class ApplicationExpressionFunctionProvider
implements ExpressionFunctionProvider {
    private static Front50Service front50Service = null;
    private static ObjectMapper objectMapper = null;

    ApplicationExpressionFunctionProvider(ObjectMapper objectMapper, Optional<Front50Service> front50Service) {
        front50Service.ifPresent(service -> {
            front50Service = service;
        });
        ApplicationExpressionFunctionProvider.objectMapper = objectMapper;
    }

    @Nullable
    public String getNamespace() {
        return null;
    }

    @NotNull
    public ExpressionFunctionProvider.Functions getFunctions() {
        return new ExpressionFunctionProvider.Functions(new ExpressionFunctionProvider.FunctionDefinition[]{new ExpressionFunctionProvider.FunctionDefinition("applicationMetadata", "Get application metadata for a specific application", new ExpressionFunctionProvider.FunctionParameter[]{new ExpressionFunctionProvider.FunctionParameter(String.class, "applicationName", "Application to get metadata for")})});
    }

    public static Map<String, Object> applicationMetadata(String applicationName) {
        if (front50Service == null) {
            throw new SpelHelperFunctionException("front50 service is missing. It's required when using applicationMetadata function");
        }
        try {
            RetrySupport retrySupport = new RetrySupport();
            Application application = (Application)retrySupport.retry(() -> front50Service.get(applicationName), 3, 1000L, true);
            return (Map)objectMapper.convertValue((Object)application, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            throw new SpelHelperFunctionException(String.format("Application metadata for application '%s' could not be retrieved", applicationName), (Throwable)e);
        }
    }
}

