/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.pipeline;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.netflix.spinnaker.kork.artifacts.model.ExpectedArtifact;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.TaskNode;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.tasks.MonitorPipelineTask;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipeline.tasks.artifacts.BindProducedArtifactsTask;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MonitorPipelineStage
implements StageDefinitionBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String PIPELINE_CONFIG_TYPE = StageDefinitionBuilder.getType(MonitorPipelineStage.class);
    final ExecutionRepository executionRepository;

    @Autowired
    public MonitorPipelineStage(ExecutionRepository executionRepository) {
        this.executionRepository = executionRepository;
    }

    public void taskGraph(@Nonnull StageExecution stage, @Nonnull TaskNode.Builder builder) {
        StageParameters stageData = (StageParameters)stage.mapTo(StageParameters.class);
        builder.withTask("monitorPipeline", MonitorPipelineTask.class);
        if (stageData.expectedArtifacts != null) {
            builder.withTask("bindProducedArtifacts", BindProducedArtifactsTask.class);
        }
    }

    public static class StageParameters {
        @Deprecated
        public String executionId;
        public List<String> executionIds;
        public MonitorBehavior monitorBehavior;
        public List<ExpectedArtifact> expectedArtifacts;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class StageResult {
        public Map<String, ChildPipelineStatusDetails> executionStatuses;
        @JsonIgnore
        private final Map<String, Object> monitoredPipelineContext = new HashMap<String, Object>();

        @JsonAnyGetter
        public Map<String, Object> pipelineContext() {
            return this.monitoredPipelineContext;
        }

        public void insertPipelineContext(Map<String, Object> pipelineContext) {
            this.monitoredPipelineContext.putAll(pipelineContext);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ChildPipelineStatusDetails {
        public ExecutionStatus status;
        public String application;
        public ChildPipelineException exception;
    }

    public static class ChildPipelineException {
        public ChildPipelineExceptionSource source = new ChildPipelineExceptionSource();
        public ChildPipelineExceptionDetails details = new ChildPipelineExceptionDetails();

        public static class ChildPipelineExceptionSource {
            public String executionId;
            public String stageId;
            public String stageName;
            public int stageIndex;
        }

        public static class ChildPipelineExceptionDetails {
            public List<String> errors;
        }
    }

    public static enum MonitorBehavior {
        WaitForAllToComplete,
        FailFast;

    }
}

