/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.scheduling;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.LongTaskTimer;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerHttpException;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.notifications.AbstractPollingNotificationAgent;
import com.netflix.spinnaker.orca.notifications.NotificationClusterLock;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import java.time.Clock;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="${pollers.unused-pipelines-disable.enabled:false} && ${execution-repository.sql.enabled:false}")
public class UnusedPipelineDisablePollingNotificationAgent
extends AbstractPollingNotificationAgent {
    Front50Service front50service;
    private static final List<String> COMPLETED_STATUSES = ExecutionStatus.COMPLETED.stream().map(Enum::toString).collect(Collectors.toList());
    private final Logger log = LoggerFactory.getLogger(UnusedPipelineDisablePollingNotificationAgent.class);
    private final Clock clock;
    private final ExecutionRepository executionRepository;
    private final Registry registry;
    private final long pollingIntervalSec;
    private final int thresholdDays;
    private final boolean dryRun;
    private final Id timerId;

    @Autowired
    public UnusedPipelineDisablePollingNotificationAgent(NotificationClusterLock clusterLock, ExecutionRepository executionRepository, Front50Service front50Service, Clock clock, Registry registry, @Value(value="${pollers.unused-pipelines-disable.interval-sec:3600}") long pollingIntervalSec, @Value(value="${pollers.unused-pipelines-disable.threshold-days:365}") int thresholdDays, @Value(value="${pollers.unused-pipelines-disable.dry-run:true}") boolean dryRun) {
        super(clusterLock);
        this.executionRepository = executionRepository;
        this.clock = clock;
        this.registry = registry;
        this.pollingIntervalSec = pollingIntervalSec;
        this.thresholdDays = thresholdDays;
        this.dryRun = dryRun;
        this.front50service = front50Service;
        this.timerId = registry.createId("pollers.unusedPipelineDisable.timing");
    }

    protected long getPollingInterval() {
        return this.pollingIntervalSec * 1000L;
    }

    protected String getNotificationType() {
        return UnusedPipelineDisablePollingNotificationAgent.class.getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tick() {
        LongTaskTimer timer = this.registry.longTaskTimer(this.timerId);
        long timerId = timer.start();
        try {
            this.executionRepository.retrieveAllApplicationNames(ExecutionType.PIPELINE).forEach(app -> {
                this.log.debug("Evaluating " + app + " for unused pipelines");
                List<String> pipelineConfigIds = this.front50service.getPipelines((String)app, false, true).stream().map(p -> (String)p.get("id")).collect(Collectors.toList());
                ExecutionRepository.ExecutionCriteria criteria = new ExecutionRepository.ExecutionCriteria();
                criteria.setStatuses(COMPLETED_STATUSES);
                criteria.setStartTimeCutoff(this.clock.instant().atZone(ZoneOffset.UTC).minusDays(this.thresholdDays).toInstant());
                List orcaExecutionsPipelineConfigIds = this.executionRepository.retrievePipelineConfigIdsForApplicationWithCriteria(app, criteria);
                this.disableAppPipelines((String)app, orcaExecutionsPipelineConfigIds, pipelineConfigIds);
            });
        }
        catch (Exception e) {
            this.log.error("Disabling pipelines failed", (Throwable)e);
        }
        finally {
            timer.stop(timerId);
        }
    }

    public void disableAppPipelines(String app, List<String> orcaExecutionsPipelineConfigIds, List<String> front50PipelineConfigIds) {
        List<String> front50PipelineConfigIdsNotExecuted = front50PipelineConfigIds.stream().filter(p -> !orcaExecutionsPipelineConfigIds.contains(p)).collect(Collectors.toList());
        this.log.info("Found " + front50PipelineConfigIdsNotExecuted.size() + " pipelines to disable for Application " + app);
        front50PipelineConfigIdsNotExecuted.forEach(p -> {
            if (!this.dryRun) {
                this.log.debug("Disabling pipeline execution " + p);
                this.disableFront50PipelineConfigId((String)p);
            } else {
                this.log.info("DryRun mode: Disabling pipeline execution " + p);
            }
        });
    }

    public void disableFront50PipelineConfigId(String pipelineConfigId) {
        Map<String, Object> pipeline = this.front50service.getPipeline(pipelineConfigId);
        if (pipeline.get("disabled") == null || !((Boolean)pipeline.get("disabled")).booleanValue()) {
            pipeline.put("disabled", true);
            try {
                this.front50service.updatePipeline(pipelineConfigId, pipeline);
            }
            catch (SpinnakerHttpException e) {
                if (Arrays.asList(404, 403).contains(e.getResponseCode())) {
                    this.log.warn("Failed to disable pipeline " + pipelineConfigId + " due to " + e.getMessage());
                }
                throw e;
            }
        }
    }
}

