/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.front50.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerHttpException;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.PipelineModelMutator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import retrofit.client.Response;

@Component
public class SavePipelineTask
implements RetryableTask {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Front50Service front50Service;
    private final List<PipelineModelMutator> pipelineModelMutators;
    ObjectMapper objectMapper;

    @Autowired
    SavePipelineTask(Optional<Front50Service> front50Service, Optional<List<PipelineModelMutator>> pipelineModelMutators, ObjectMapper objectMapper) {
        this.front50Service = front50Service.orElse(null);
        this.pipelineModelMutators = pipelineModelMutators.orElse(new ArrayList());
        this.objectMapper = objectMapper;
    }

    public TaskResult execute(StageExecution stage) {
        if (this.front50Service == null) {
            throw new UnsupportedOperationException("Front50 is not enabled, no way to save pipeline. Fix this by setting front50.enabled: true");
        }
        Map pipeline = new HashMap();
        List<Map<String, Object>> pipelines = new ArrayList();
        boolean isSavingMultiplePipelines = stage.getContext().getOrDefault("isSavingMultiplePipelines", false);
        boolean isBulkSavingPipelines = stage.getContext().getOrDefault("isBulkSavingPipelines", false);
        boolean staleCheck = Optional.ofNullable(stage.getContext().get("staleCheck")).orElse(false);
        if (isBulkSavingPipelines) {
            if (!stage.getContext().containsKey("pipelines")) {
                throw new IllegalArgumentException("pipelines context must be provided when saving multiple pipelines");
            }
            pipelines = (List)stage.decodeBase64("/pipelines", List.class);
            this.log.info("Bulk saving the following pipelines: {}", pipelines.stream().map(p -> p.get("name")).collect(Collectors.toList()));
        } else {
            if (!stage.getContext().containsKey("pipeline")) {
                throw new IllegalArgumentException("pipeline context must be provided when saving a single pipeline");
            }
            pipeline = !(stage.getContext().get("pipeline") instanceof String) ? (Map)stage.getContext().get("pipeline") : (Map)stage.decodeBase64("/pipeline", Map.class);
            pipelines.add(pipeline);
            this.log.info("Saving single pipeline {}", pipeline.get("name"));
        }
        for (Map map : pipelines) {
            String serviceAccount;
            Map<String, Object> existingPipeline;
            if (!map.containsKey("index") && (existingPipeline = this.fetchExistingPipeline(map)) != null) {
                map.put("index", existingPipeline.get("index"));
            }
            if ((serviceAccount = (String)stage.getContext().get("pipeline.serviceAccount")) != null) {
                this.updateServiceAccount(map, serviceAccount);
            }
            if (stage.getContext().get("pipeline.id") != null && map.get("id") == null && !isSavingMultiplePipelines) {
                map.put("id", stage.getContext().get("pipeline.id"));
                map.put("regenerateCronTriggerIds", true);
            }
            this.pipelineModelMutators.stream().filter(m -> m.supports(pipe)).forEach(m -> m.mutate(pipe));
        }
        Response response = isBulkSavingPipelines ? this.front50Service.savePipelines(pipelines, staleCheck) : this.front50Service.savePipeline(pipeline, staleCheck);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("notification.type", "savepipeline");
        hashMap.put("application", stage.getContext().get("application"));
        Map saveResult = new HashMap();
        try {
            saveResult = (Map)this.objectMapper.readValue(response.getBody().in(), Map.class);
        }
        catch (Exception e) {
            this.log.error("Unable to deserialize save pipeline(s) result, reason: ", (Throwable)e);
        }
        if (isBulkSavingPipelines) {
            hashMap.put("bulksave", saveResult);
        } else {
            hashMap.put("pipeline.name", pipeline.get("name"));
            hashMap.put("pipeline.id", saveResult.getOrDefault("id", pipeline.getOrDefault("id", "")));
        }
        ExecutionStatus status = response.getStatus() == HttpStatus.OK.value() ? ExecutionStatus.SUCCEEDED : (isSavingMultiplePipelines ? ExecutionStatus.FAILED_CONTINUE : ExecutionStatus.TERMINAL);
        return TaskResult.builder((ExecutionStatus)status).context(hashMap).build();
    }

    public long getBackoffPeriod() {
        return 1000L;
    }

    public long getTimeout() {
        return TimeUnit.SECONDS.toMillis(30L);
    }

    private void updateServiceAccount(Map<String, Object> pipeline, String serviceAccount) {
        if (StringUtils.isEmpty((CharSequence)serviceAccount) || !pipeline.containsKey("triggers")) {
            return;
        }
        List triggers = (List)pipeline.get("triggers");
        List roles = (List)pipeline.get("roles");
        if (roles == null || roles.isEmpty()) {
            triggers.forEach(t -> t.remove("runAsUser", serviceAccount));
            return;
        }
        triggers.stream().filter(t -> this.runAsUserIsNullOrManagedServiceAccount((String)t.get("runAsUser"))).forEach(t -> t.put("runAsUser", serviceAccount));
    }

    private Map<String, Object> fetchExistingPipeline(Map<String, Object> newPipeline) {
        block3: {
            String newPipelineID = (String)newPipeline.get("id");
            if (StringUtils.isNotEmpty((CharSequence)newPipelineID)) {
                try {
                    return this.front50Service.getPipeline(newPipelineID);
                }
                catch (SpinnakerHttpException e) {
                    if (e.getResponseCode() != 404) break block3;
                    this.log.debug("Existing pipeline with id {} not found. Returning null.", (Object)newPipelineID);
                }
            }
        }
        return null;
    }

    private boolean runAsUserIsNullOrManagedServiceAccount(String runAsUser) {
        return runAsUser == null || runAsUser.endsWith("@managed-service-account") || runAsUser.endsWith("@shared-managed-service-account");
    }
}

