/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.cf.pipeline.expressions.functions;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.netflix.spinnaker.kork.api.expressions.ExpressionFunctionProvider;
import com.netflix.spinnaker.kork.expressions.ExpressionFunctionProvider;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.jackson.OrcaObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class ServiceKeyExpressionFunctionProvider
implements ExpressionFunctionProvider {
    private static final String CREATE_SERVICE_KEY_STAGE_NAME = "createServiceKey";
    private static final ObjectMapper objectMapper = OrcaObjectMapper.getInstance();

    @Nullable
    public String getNamespace() {
        return null;
    }

    @NotNull
    public ExpressionFunctionProvider.Functions getFunctions() {
        return new ExpressionFunctionProvider.Functions(new ExpressionFunctionProvider.FunctionDefinition[]{new ExpressionFunctionProvider.FunctionDefinition("cfServiceKey", "A shortcut to refer to a service key which has been created in the given stage", new ExpressionFunctionProvider.FunctionParameter[]{new ExpressionFunctionProvider.FunctionParameter(PipelineExecution.class, "execution", "The execution within which to search for stages"), new ExpressionFunctionProvider.FunctionParameter(String.class, "idOrName", "A stage name or stage ID to match")})});
    }

    public static Map<String, Object> cfServiceKey(PipelineExecution execution, String idOrName) {
        return execution.getStages().stream().filter(ServiceKeyExpressionFunctionProvider.matchesServiceKeyStage(idOrName)).findFirst().map(stage -> {
            HashMap serviceKeyDetails = new HashMap();
            Optional.ofNullable(stage.getContext().get("kato.tasks")).ifPresent(k -> {
                List katoTasks = (List)k;
                try {
                    ServiceKeyKatoTask katoTask = (ServiceKeyKatoTask)objectMapper.readValue((JsonParser)new TreeTraversingParser(objectMapper.valueToTree(katoTasks.get(0)), (ObjectCodec)objectMapper), ServiceKeyKatoTask.class);
                    serviceKeyDetails.putAll(katoTask.getResultObjects().get(0).getServiceKey());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            return serviceKeyDetails;
        }).orElse(Collections.emptyMap());
    }

    private static Predicate<StageExecution> matchesServiceKeyStage(String idOrName) {
        return stage -> CREATE_SERVICE_KEY_STAGE_NAME.equals(stage.getType()) && stage.getStatus() == ExecutionStatus.SUCCEEDED && (Objects.equals(idOrName, stage.getName()) || Objects.equals(idOrName, stage.getId()));
    }

    private static class ServiceKeyKatoTask {
        private List<ServiceKeyResult> resultObjects;

        public List<ServiceKeyResult> getResultObjects() {
            return this.resultObjects;
        }

        public void setResultObjects(List<ServiceKeyResult> resultObjects) {
            this.resultObjects = resultObjects;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServiceKeyKatoTask)) {
                return false;
            }
            ServiceKeyKatoTask other = (ServiceKeyKatoTask)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ServiceKeyResult> this$resultObjects = this.getResultObjects();
            List<ServiceKeyResult> other$resultObjects = other.getResultObjects();
            return !(this$resultObjects == null ? other$resultObjects != null : !((Object)this$resultObjects).equals(other$resultObjects));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServiceKeyKatoTask;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ServiceKeyResult> $resultObjects = this.getResultObjects();
            result = result * 59 + ($resultObjects == null ? 43 : ((Object)$resultObjects).hashCode());
            return result;
        }

        public String toString() {
            return "ServiceKeyExpressionFunctionProvider.ServiceKeyKatoTask(resultObjects=" + this.getResultObjects() + ")";
        }

        private static class ServiceKeyResult {
            private Map<String, Object> serviceKey;

            public Map<String, Object> getServiceKey() {
                return this.serviceKey;
            }

            public void setServiceKey(Map<String, Object> serviceKey) {
                this.serviceKey = serviceKey;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ServiceKeyResult)) {
                    return false;
                }
                ServiceKeyResult other = (ServiceKeyResult)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$serviceKey = this.getServiceKey();
                Map<String, Object> other$serviceKey = other.getServiceKey();
                return !(this$serviceKey == null ? other$serviceKey != null : !((Object)this$serviceKey).equals(other$serviceKey));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ServiceKeyResult;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $serviceKey = this.getServiceKey();
                result = result * 59 + ($serviceKey == null ? 43 : ((Object)$serviceKey).hashCode());
                return result;
            }

            public String toString() {
                return "ServiceKeyExpressionFunctionProvider.ServiceKeyKatoTask.ServiceKeyResult(serviceKey=" + this.getServiceKey() + ")";
            }
        }
    }
}

