/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.InterlinkConfigurationProperties;
import com.netflix.spinnaker.kork.pubsub.PubsubPublishers;
import com.netflix.spinnaker.kork.pubsub.aws.SNSPublisherProvider;
import com.netflix.spinnaker.kork.pubsub.aws.api.AmazonPubsubMessageHandler;
import com.netflix.spinnaker.kork.pubsub.aws.api.AmazonPubsubMessageHandlerFactory;
import com.netflix.spinnaker.kork.pubsub.aws.config.AmazonPubsubConfig;
import com.netflix.spinnaker.kork.pubsub.aws.config.AmazonPubsubProperties;
import com.netflix.spinnaker.kork.pubsub.config.PubsubConfig;
import com.netflix.spinnaker.orca.interlink.Interlink;
import com.netflix.spinnaker.orca.interlink.MessageFlagger;
import com.netflix.spinnaker.orca.interlink.aws.InterlinkAmazonMessageHandler;
import com.netflix.spinnaker.orca.pipeline.CompoundExecutionOperator;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import java.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={PubsubConfig.class, AmazonPubsubConfig.class})
@ConditionalOnProperty(value={"interlink.enabled"})
@EnableConfigurationProperties(value={InterlinkConfigurationProperties.class})
public class InterlinkConfiguration {
    private static final Logger log = LoggerFactory.getLogger(InterlinkConfiguration.class);

    @Bean
    @ConditionalOnProperty(value={"pubsub.enabled", "pubsub.amazon.enabled"})
    public AmazonPubsubMessageHandlerFactory amazonPubsubMessageHandlerFactory(final ObjectMapper objectMapper, final ExecutionRepository repository, final CompoundExecutionOperator executionOperator) {
        return new AmazonPubsubMessageHandlerFactory(){

            public AmazonPubsubMessageHandler create(AmazonPubsubProperties.AmazonPubsubSubscription subscription) {
                if (!"interlink".equals(subscription.getName())) {
                    log.debug("Skipping non-interlink pubsub subscription named '{}'", (Object)subscription.getName());
                    return null;
                }
                return new InterlinkAmazonMessageHandler(objectMapper, repository, executionOperator);
            }
        };
    }

    @Bean
    @ConditionalOnProperty(value={"pubsub.enabled", "pubsub.amazon.enabled"})
    public Interlink amazonInterlink(PubsubPublishers publishers, ObjectMapper objectMapper, InterlinkConfigurationProperties properties, Registry registry, Clock clock, SNSPublisherProvider snsProvider) {
        return new Interlink(publishers, objectMapper, new MessageFlagger(clock, properties.flagger), registry);
    }
}

