/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.interlink;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.kork.exceptions.ConfigurationException;
import com.netflix.spinnaker.kork.pubsub.PubsubPublishers;
import com.netflix.spinnaker.kork.pubsub.model.PubsubPublisher;
import com.netflix.spinnaker.orca.interlink.MessageFlaggedException;
import com.netflix.spinnaker.orca.interlink.MessageFlagger;
import com.netflix.spinnaker.orca.interlink.events.InterlinkEvent;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Interlink {
    private static final Logger log = LoggerFactory.getLogger(Interlink.class);
    public static final String SUBSCRIPTION_NAME = "interlink";
    private final PubsubPublisher publisher;
    private final ObjectMapper objectMapper;
    private final MessageFlagger flagger;
    private Counter flaggedCounter;

    public Interlink(PubsubPublishers publishers, ObjectMapper objectMapper, MessageFlagger flagger, Registry registry) {
        this.objectMapper = objectMapper;
        this.flagger = flagger;
        this.publisher = publishers.getAll().stream().filter(pubsubPublisher -> SUBSCRIPTION_NAME.equals(pubsubPublisher.getTopicName())).findFirst().orElse(null);
        if (this.publisher == null) {
            throw new ConfigurationException("could not find interlink publisher in [" + publishers.getAll().stream().map(PubsubPublisher::getTopicName).collect(Collectors.joining(", ")) + "]");
        }
        this.flaggedCounter = registry.counter("pubsub." + this.publisher.getPubsubSystem() + ".flagged", new String[]{"subscription", this.publisher.getName()});
    }

    public void publish(InterlinkEvent event) {
        try {
            this.flagger.process(event);
        }
        catch (MessageFlaggedException e) {
            log.warn("Will not publish event {} to interlink", (Object)event, (Object)e);
            this.flaggedCounter.increment();
            return;
        }
        try {
            this.publisher.publish(this.objectMapper.writeValueAsString((Object)event));
        }
        catch (JsonProcessingException e) {
            log.error("Failed to serialize event {}", (Object)event, (Object)e);
        }
    }
}

