/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.interlink;

import com.google.common.base.Preconditions;
import com.google.common.collect.EvictingQueue;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.netflix.spinnaker.config.InterlinkConfigurationProperties;
import com.netflix.spinnaker.orca.interlink.MessageFlaggedException;
import com.netflix.spinnaker.orca.interlink.events.InterlinkEvent;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/netflix/spinnaker/orca/interlink/MessageFlagger;", "", "clock", "Ljava/time/Clock;", "props", "Lcom/netflix/spinnaker/config/InterlinkConfigurationProperties$FlaggerProperties;", "(Ljava/time/Clock;Lcom/netflix/spinnaker/config/InterlinkConfigurationProperties$FlaggerProperties;)V", "getClock", "()Ljava/time/Clock;", "hasher", "Lcom/google/common/hash/HashFunction;", "kotlin.jvm.PlatformType", "lookback", "Ljava/time/Duration;", "mutex", "Ljava/util/concurrent/locks/ReentrantLock;", "getProps", "()Lcom/netflix/spinnaker/config/InterlinkConfigurationProperties$FlaggerProperties;", "queue", "Lcom/google/common/collect/EvictingQueue;", "Lcom/netflix/spinnaker/orca/interlink/MessageFlagger$TimestampedHash;", "process", "", "event", "Lcom/netflix/spinnaker/orca/interlink/events/InterlinkEvent;", "TimestampedHash", "orca-interlink"})
public final class MessageFlagger {
    private final EvictingQueue<TimestampedHash> queue;
    private final HashFunction hasher;
    private final Duration lookback;
    private final ReentrantLock mutex;
    @NotNull
    private final Clock clock;
    @NotNull
    private final InterlinkConfigurationProperties.FlaggerProperties props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void process(@NotNull InterlinkEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.props.enabled) {
            return;
        }
        HashCode hash = this.hasher.hashString((CharSequence)event.getFingerprint(), Charsets.UTF_8);
        Instant now = this.clock.instant();
        Instant timeCutoff = now.minus(this.lookback);
        try {
            void $this$filterTo$iv$iv;
            this.mutex.lock();
            Iterable $this$filter$iv = (Iterable)this.queue;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TimestampedHash it = (TimestampedHash)element$iv$iv;
                boolean bl = false;
                if (!(it.getTimestamp().isAfter(timeCutoff) && Intrinsics.areEqual((Object)it.getHash(), (Object)hash))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List matches = (List)destination$iv$iv;
            Collection collection = matches;
            boolean bl = false;
            if (collection.size() >= this.props.threshold) {
                collection = matches;
                bl = false;
                throw (Throwable)((Object)new MessageFlaggedException("Event '" + event + "' with fingerprint '" + event.getFingerprint() + "' has been encountered " + collection.size() + " times in the last " + this.props.lookbackSeconds + 's'));
            }
            Instant instant = now;
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now");
            HashCode hashCode = hash;
            Intrinsics.checkNotNullExpressionValue((Object)hashCode, (String)"hash");
            this.queue.add((Object)new TimestampedHash(instant, hashCode));
        }
        finally {
            this.mutex.unlock();
        }
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @NotNull
    public final InterlinkConfigurationProperties.FlaggerProperties getProps() {
        return this.props;
    }

    public MessageFlagger(@NotNull Clock clock, @NotNull InterlinkConfigurationProperties.FlaggerProperties props) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        this.clock = clock;
        this.props = props;
        EvictingQueue evictingQueue = EvictingQueue.create((int)this.props.maxSize);
        Intrinsics.checkNotNullExpressionValue((Object)evictingQueue, (String)"EvictingQueue.create(props.maxSize)");
        this.queue = evictingQueue;
        this.hasher = Hashing.goodFastHash((int)64);
        this.lookback = Duration.ofSeconds(this.props.lookbackSeconds);
        this.mutex = new ReentrantLock();
        Preconditions.checkArgument((this.props.maxSize >= this.props.threshold ? 1 : 0) != 0, (String)"maxSize (%s) has to be larger than threshold (%s)", (int)this.props.maxSize, (int)this.props.threshold);
        Preconditions.checkArgument((this.props.threshold > 0 ? 1 : 0) != 0, (String)"threshold (%s) has to be > 0", (int)this.props.threshold);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/netflix/spinnaker/orca/interlink/MessageFlagger$TimestampedHash;", "", "timestamp", "Ljava/time/Instant;", "hash", "Lcom/google/common/hash/HashCode;", "(Ljava/time/Instant;Lcom/google/common/hash/HashCode;)V", "getHash", "()Lcom/google/common/hash/HashCode;", "getTimestamp", "()Ljava/time/Instant;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "orca-interlink"})
    private static final class TimestampedHash {
        @NotNull
        private final Instant timestamp;
        @NotNull
        private final HashCode hash;

        @NotNull
        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final HashCode getHash() {
            return this.hash;
        }

        public TimestampedHash(@NotNull Instant timestamp, @NotNull HashCode hash) {
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            this.timestamp = timestamp;
            this.hash = hash;
        }

        @NotNull
        public final Instant component1() {
            return this.timestamp;
        }

        @NotNull
        public final HashCode component2() {
            return this.hash;
        }

        @NotNull
        public final TimestampedHash copy(@NotNull Instant timestamp, @NotNull HashCode hash) {
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            return new TimestampedHash(timestamp, hash);
        }

        public static /* synthetic */ TimestampedHash copy$default(TimestampedHash timestampedHash, Instant instant, HashCode hashCode, int n, Object object) {
            if ((n & 1) != 0) {
                instant = timestampedHash.timestamp;
            }
            if ((n & 2) != 0) {
                hashCode = timestampedHash.hash;
            }
            return timestampedHash.copy(instant, hashCode);
        }

        @NotNull
        public String toString() {
            return "TimestampedHash(timestamp=" + this.timestamp + ", hash=" + this.hash + ")";
        }

        public int hashCode() {
            Instant instant = this.timestamp;
            HashCode hashCode = this.hash;
            return (instant != null ? ((Object)instant).hashCode() : 0) * 31 + (hashCode != null ? hashCode.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TimestampedHash)) break block3;
                    TimestampedHash timestampedHash = (TimestampedHash)object;
                    if (!Intrinsics.areEqual((Object)this.timestamp, (Object)timestampedHash.timestamp) || !Intrinsics.areEqual((Object)this.hash, (Object)timestampedHash.hash)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

