/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.interlink.aws;

import com.amazonaws.services.sqs.model.Message;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.annotations.VisibleForTesting;
import com.netflix.spinnaker.kork.common.Header;
import com.netflix.spinnaker.kork.pubsub.aws.NotificationMessage;
import com.netflix.spinnaker.kork.pubsub.aws.api.AmazonPubsubMessageHandler;
import com.netflix.spinnaker.orca.interlink.InterlinkMessageHandlingException;
import com.netflix.spinnaker.orca.interlink.events.InterlinkEvent;
import com.netflix.spinnaker.orca.pipeline.CompoundExecutionOperator;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class InterlinkAmazonMessageHandler
implements AmazonPubsubMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(InterlinkAmazonMessageHandler.class);
    private final ObjectMapper objectMapper;
    private final ExecutionRepository executionRepository;
    private final CompoundExecutionOperator executionOperator;

    public InterlinkAmazonMessageHandler(ObjectMapper objectMapper, ExecutionRepository executionRepository, CompoundExecutionOperator executionOperator) {
        this.objectMapper = objectMapper;
        this.executionRepository = executionRepository;
        this.executionOperator = executionOperator;
    }

    public void handleMessage(Message message) {
        try {
            NotificationMessage snsMessage = (NotificationMessage)this.objectMapper.readValue(message.getBody(), NotificationMessage.class);
            InterlinkEvent event = (InterlinkEvent)this.objectMapper.readValue(snsMessage.getMessage(), InterlinkEvent.class);
            log.debug("Received interlink event {}", (Object)event);
            this.handleInternal(event);
        }
        catch (JsonProcessingException e) {
            throw new InterlinkMessageHandlingException(e);
        }
    }

    @VisibleForTesting
    void handleInternal(InterlinkEvent event) {
        try {
            MDC.put((String)Header.EXECUTION_ID.getHeader(), (String)event.getExecutionId());
            if (this.executionRepository.handlesPartition(event.getPartition())) {
                event.withObjectMapper(this.objectMapper).applyTo(this.executionOperator);
            } else {
                log.debug("Execution repository with local partition {} can't handle this event {} so it will not be applied", (Object)this.executionRepository.getPartition(), (Object)event);
            }
        }
        finally {
            MDC.remove((String)Header.EXECUTION_ID.getHeader());
        }
    }
}

