/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.interlink.events;

import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.interlink.events.InterlinkEvent;
import com.netflix.spinnaker.orca.pipeline.CompoundExecutionOperator;
import javax.annotation.Nullable;
import lombok.NonNull;

public class CancelInterlinkEvent
implements InterlinkEvent {
    final InterlinkEvent.EventType eventType = InterlinkEvent.EventType.CANCEL;
    @Nullable
    String partition;
    @NonNull
    ExecutionType executionType;
    @NonNull
    String executionId;
    @Nullable
    String canceledBy;
    @Nullable
    String cancellationReason;

    public CancelInterlinkEvent(@NonNull ExecutionType executionType, @NonNull String executionId, @Nullable String canceledBy, @Nullable String cancellationReason) {
        if (executionType == null) {
            throw new NullPointerException("executionType is marked non-null but is null");
        }
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        this.executionType = executionType;
        this.executionId = executionId;
        this.canceledBy = canceledBy;
        this.cancellationReason = cancellationReason;
    }

    @Override
    public void applyTo(CompoundExecutionOperator executionOperator) {
        executionOperator.cancel(this.executionType, this.executionId, this.canceledBy, this.cancellationReason);
    }

    @Override
    public InterlinkEvent.EventType getEventType() {
        return this.eventType;
    }

    @Override
    @Nullable
    public String getPartition() {
        return this.partition;
    }

    @Override
    @NonNull
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    @NonNull
    public String getExecutionId() {
        return this.executionId;
    }

    @Nullable
    public String getCanceledBy() {
        return this.canceledBy;
    }

    @Nullable
    public String getCancellationReason() {
        return this.cancellationReason;
    }

    @Override
    public void setPartition(@Nullable String partition) {
        this.partition = partition;
    }

    public void setExecutionType(@NonNull ExecutionType executionType) {
        if (executionType == null) {
            throw new NullPointerException("executionType is marked non-null but is null");
        }
        this.executionType = executionType;
    }

    public void setExecutionId(@NonNull String executionId) {
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        this.executionId = executionId;
    }

    public void setCanceledBy(@Nullable String canceledBy) {
        this.canceledBy = canceledBy;
    }

    public void setCancellationReason(@Nullable String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CancelInterlinkEvent)) {
            return false;
        }
        CancelInterlinkEvent other = (CancelInterlinkEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InterlinkEvent.EventType this$eventType = this.getEventType();
        InterlinkEvent.EventType other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !((Object)((Object)this$eventType)).equals((Object)other$eventType)) {
            return false;
        }
        String this$partition = this.getPartition();
        String other$partition = other.getPartition();
        if (this$partition == null ? other$partition != null : !this$partition.equals(other$partition)) {
            return false;
        }
        ExecutionType this$executionType = this.getExecutionType();
        ExecutionType other$executionType = other.getExecutionType();
        if (this$executionType == null ? other$executionType != null : !this$executionType.equals(other$executionType)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        String this$canceledBy = this.getCanceledBy();
        String other$canceledBy = other.getCanceledBy();
        if (this$canceledBy == null ? other$canceledBy != null : !this$canceledBy.equals(other$canceledBy)) {
            return false;
        }
        String this$cancellationReason = this.getCancellationReason();
        String other$cancellationReason = other.getCancellationReason();
        return !(this$cancellationReason == null ? other$cancellationReason != null : !this$cancellationReason.equals(other$cancellationReason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CancelInterlinkEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InterlinkEvent.EventType $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : ((Object)((Object)$eventType)).hashCode());
        String $partition = this.getPartition();
        result = result * 59 + ($partition == null ? 43 : $partition.hashCode());
        ExecutionType $executionType = this.getExecutionType();
        result = result * 59 + ($executionType == null ? 43 : $executionType.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        String $canceledBy = this.getCanceledBy();
        result = result * 59 + ($canceledBy == null ? 43 : $canceledBy.hashCode());
        String $cancellationReason = this.getCancellationReason();
        result = result * 59 + ($cancellationReason == null ? 43 : $cancellationReason.hashCode());
        return result;
    }

    public String toString() {
        return "CancelInterlinkEvent(eventType=" + this.getEventType() + ", partition=" + this.getPartition() + ", executionType=" + this.getExecutionType() + ", executionId=" + this.getExecutionId() + ", canceledBy=" + this.getCanceledBy() + ", cancellationReason=" + this.getCancellationReason() + ")";
    }

    public CancelInterlinkEvent(@Nullable String partition, @NonNull ExecutionType executionType, @NonNull String executionId, @Nullable String canceledBy, @Nullable String cancellationReason) {
        if (executionType == null) {
            throw new NullPointerException("executionType is marked non-null but is null");
        }
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        this.partition = partition;
        this.executionType = executionType;
        this.executionId = executionId;
        this.canceledBy = canceledBy;
        this.cancellationReason = cancellationReason;
    }

    public CancelInterlinkEvent() {
    }
}

