/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.interlink.events;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.interlink.events.CancelInterlinkEvent;
import com.netflix.spinnaker.orca.interlink.events.DeleteInterlinkEvent;
import com.netflix.spinnaker.orca.interlink.events.PatchStageInterlinkEvent;
import com.netflix.spinnaker.orca.interlink.events.PauseInterlinkEvent;
import com.netflix.spinnaker.orca.interlink.events.RestartStageInterlinkEvent;
import com.netflix.spinnaker.orca.interlink.events.ResumeInterlinkEvent;
import com.netflix.spinnaker.orca.pipeline.CompoundExecutionOperator;
import javax.validation.constraints.NotNull;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="eventType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CancelInterlinkEvent.class, name="CANCEL"), @JsonSubTypes.Type(value=PauseInterlinkEvent.class, name="PAUSE"), @JsonSubTypes.Type(value=ResumeInterlinkEvent.class, name="RESUME"), @JsonSubTypes.Type(value=DeleteInterlinkEvent.class, name="DELETE"), @JsonSubTypes.Type(value=PatchStageInterlinkEvent.class, name="PATCH"), @JsonSubTypes.Type(value=RestartStageInterlinkEvent.class, name="RESTART")})
public interface InterlinkEvent {
    @JsonIgnore
    public EventType getEventType();

    public ExecutionType getExecutionType();

    public String getExecutionId();

    public String getPartition();

    public void setPartition(String var1);

    default public InterlinkEvent withPartition(String partition) {
        this.setPartition(partition);
        return this;
    }

    public void applyTo(CompoundExecutionOperator var1);

    @JsonIgnore
    @NotNull
    default public String getFingerprint() {
        return this.getEventType() + ":" + this.getExecutionType() + ":" + this.getExecutionId();
    }

    default public InterlinkEvent withObjectMapper(ObjectMapper objectMapper) {
        return this;
    }

    public static enum EventType {
        CANCEL,
        PAUSE,
        DELETE,
        RESUME,
        PATCH,
        RESTART;

    }
}

