/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.interlink.events;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.interlink.events.InterlinkEvent;
import com.netflix.spinnaker.orca.pipeline.CompoundExecutionOperator;
import com.netflix.spinnaker.orca.pipeline.model.StageExecutionImpl;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchStageInterlinkEvent
implements InterlinkEvent {
    private static final Logger log = LoggerFactory.getLogger(PatchStageInterlinkEvent.class);
    final InterlinkEvent.EventType eventType = InterlinkEvent.EventType.PATCH;
    @Nullable
    String partition;
    @NonNull
    ExecutionType executionType;
    @NonNull
    String executionId;
    @NonNull
    String stageId;
    @NonNull
    String stageBody;
    @JsonIgnore
    @Nullable
    ObjectMapper mapper;

    public PatchStageInterlinkEvent(@NonNull ExecutionType executionType, @NonNull String executionId, @NonNull String stageId, @NonNull String stageBody) {
        if (executionType == null) {
            throw new NullPointerException("executionType is marked non-null but is null");
        }
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        if (stageId == null) {
            throw new NullPointerException("stageId is marked non-null but is null");
        }
        if (stageBody == null) {
            throw new NullPointerException("stageBody is marked non-null but is null");
        }
        this.executionType = executionType;
        this.executionId = executionId;
        this.stageId = stageId;
        this.stageBody = stageBody;
    }

    @Override
    public void applyTo(CompoundExecutionOperator executionOperator) {
        Preconditions.checkNotNull((Object)this.mapper, (Object)"applyTo requires an ObjectMapper");
        try {
            StageExecution stageFromMessage = (StageExecution)this.mapper.readValue(this.stageBody, StageExecutionImpl.class);
            executionOperator.updateStage(this.executionType, this.executionId, this.stageId, stageFromRepo -> {
                stageFromRepo.getContext().putAll(stageFromMessage.getContext());
                if (stageFromMessage.getLastModified() != null) {
                    stageFromRepo.setLastModified(stageFromMessage.getLastModified());
                }
            });
        }
        catch (JsonProcessingException e) {
            log.error("failed to parse stageBody {}", (Object)this.stageBody, (Object)e);
        }
    }

    @Override
    public InterlinkEvent withObjectMapper(ObjectMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    @Override
    public InterlinkEvent.EventType getEventType() {
        return this.eventType;
    }

    @Override
    @Nullable
    public String getPartition() {
        return this.partition;
    }

    @Override
    @NonNull
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    @NonNull
    public String getExecutionId() {
        return this.executionId;
    }

    @NonNull
    public String getStageId() {
        return this.stageId;
    }

    @NonNull
    public String getStageBody() {
        return this.stageBody;
    }

    @Nullable
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void setPartition(@Nullable String partition) {
        this.partition = partition;
    }

    public void setExecutionType(@NonNull ExecutionType executionType) {
        if (executionType == null) {
            throw new NullPointerException("executionType is marked non-null but is null");
        }
        this.executionType = executionType;
    }

    public void setExecutionId(@NonNull String executionId) {
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        this.executionId = executionId;
    }

    public void setStageId(@NonNull String stageId) {
        if (stageId == null) {
            throw new NullPointerException("stageId is marked non-null but is null");
        }
        this.stageId = stageId;
    }

    public void setStageBody(@NonNull String stageBody) {
        if (stageBody == null) {
            throw new NullPointerException("stageBody is marked non-null but is null");
        }
        this.stageBody = stageBody;
    }

    @JsonIgnore
    public void setMapper(@Nullable ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatchStageInterlinkEvent)) {
            return false;
        }
        PatchStageInterlinkEvent other = (PatchStageInterlinkEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InterlinkEvent.EventType this$eventType = this.getEventType();
        InterlinkEvent.EventType other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !((Object)((Object)this$eventType)).equals((Object)other$eventType)) {
            return false;
        }
        String this$partition = this.getPartition();
        String other$partition = other.getPartition();
        if (this$partition == null ? other$partition != null : !this$partition.equals(other$partition)) {
            return false;
        }
        ExecutionType this$executionType = this.getExecutionType();
        ExecutionType other$executionType = other.getExecutionType();
        if (this$executionType == null ? other$executionType != null : !this$executionType.equals(other$executionType)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        String this$stageId = this.getStageId();
        String other$stageId = other.getStageId();
        if (this$stageId == null ? other$stageId != null : !this$stageId.equals(other$stageId)) {
            return false;
        }
        String this$stageBody = this.getStageBody();
        String other$stageBody = other.getStageBody();
        if (this$stageBody == null ? other$stageBody != null : !this$stageBody.equals(other$stageBody)) {
            return false;
        }
        ObjectMapper this$mapper = this.getMapper();
        ObjectMapper other$mapper = other.getMapper();
        return !(this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PatchStageInterlinkEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InterlinkEvent.EventType $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : ((Object)((Object)$eventType)).hashCode());
        String $partition = this.getPartition();
        result = result * 59 + ($partition == null ? 43 : $partition.hashCode());
        ExecutionType $executionType = this.getExecutionType();
        result = result * 59 + ($executionType == null ? 43 : $executionType.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        String $stageId = this.getStageId();
        result = result * 59 + ($stageId == null ? 43 : $stageId.hashCode());
        String $stageBody = this.getStageBody();
        result = result * 59 + ($stageBody == null ? 43 : $stageBody.hashCode());
        ObjectMapper $mapper = this.getMapper();
        result = result * 59 + ($mapper == null ? 43 : $mapper.hashCode());
        return result;
    }

    public String toString() {
        return "PatchStageInterlinkEvent(eventType=" + this.getEventType() + ", partition=" + this.getPartition() + ", executionType=" + this.getExecutionType() + ", executionId=" + this.getExecutionId() + ", stageId=" + this.getStageId() + ", stageBody=" + this.getStageBody() + ", mapper=" + this.getMapper() + ")";
    }

    public PatchStageInterlinkEvent(@Nullable String partition, @NonNull ExecutionType executionType, @NonNull String executionId, @NonNull String stageId, @NonNull String stageBody, @Nullable ObjectMapper mapper) {
        if (executionType == null) {
            throw new NullPointerException("executionType is marked non-null but is null");
        }
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        if (stageId == null) {
            throw new NullPointerException("stageId is marked non-null but is null");
        }
        if (stageBody == null) {
            throw new NullPointerException("stageBody is marked non-null but is null");
        }
        this.partition = partition;
        this.executionType = executionType;
        this.executionId = executionId;
        this.stageId = stageId;
        this.stageBody = stageBody;
        this.mapper = mapper;
    }

    public PatchStageInterlinkEvent() {
    }
}

