/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.interlink.events;

import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.interlink.events.InterlinkEvent;
import com.netflix.spinnaker.orca.pipeline.CompoundExecutionOperator;
import javax.annotation.Nullable;
import lombok.NonNull;

public class PauseInterlinkEvent
implements InterlinkEvent {
    final InterlinkEvent.EventType eventType = InterlinkEvent.EventType.PAUSE;
    @Nullable
    String partition;
    @NonNull
    ExecutionType executionType;
    @NonNull
    String executionId;
    @Nullable
    String pausedBy;

    public PauseInterlinkEvent(@NonNull ExecutionType executionType, @NonNull String executionId, @Nullable String pausedBy) {
        if (executionType == null) {
            throw new NullPointerException("executionType is marked non-null but is null");
        }
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        this.executionType = executionType;
        this.executionId = executionId;
        this.pausedBy = pausedBy;
    }

    @Override
    public void applyTo(CompoundExecutionOperator executionOperator) {
        executionOperator.pause(this.executionType, this.executionId, this.pausedBy);
    }

    @Override
    public InterlinkEvent.EventType getEventType() {
        return this.eventType;
    }

    @Override
    @Nullable
    public String getPartition() {
        return this.partition;
    }

    @Override
    @NonNull
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    @NonNull
    public String getExecutionId() {
        return this.executionId;
    }

    @Nullable
    public String getPausedBy() {
        return this.pausedBy;
    }

    @Override
    public void setPartition(@Nullable String partition) {
        this.partition = partition;
    }

    public void setExecutionType(@NonNull ExecutionType executionType) {
        if (executionType == null) {
            throw new NullPointerException("executionType is marked non-null but is null");
        }
        this.executionType = executionType;
    }

    public void setExecutionId(@NonNull String executionId) {
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        this.executionId = executionId;
    }

    public void setPausedBy(@Nullable String pausedBy) {
        this.pausedBy = pausedBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PauseInterlinkEvent)) {
            return false;
        }
        PauseInterlinkEvent other = (PauseInterlinkEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InterlinkEvent.EventType this$eventType = this.getEventType();
        InterlinkEvent.EventType other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !((Object)((Object)this$eventType)).equals((Object)other$eventType)) {
            return false;
        }
        String this$partition = this.getPartition();
        String other$partition = other.getPartition();
        if (this$partition == null ? other$partition != null : !this$partition.equals(other$partition)) {
            return false;
        }
        ExecutionType this$executionType = this.getExecutionType();
        ExecutionType other$executionType = other.getExecutionType();
        if (this$executionType == null ? other$executionType != null : !this$executionType.equals(other$executionType)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        String this$pausedBy = this.getPausedBy();
        String other$pausedBy = other.getPausedBy();
        return !(this$pausedBy == null ? other$pausedBy != null : !this$pausedBy.equals(other$pausedBy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PauseInterlinkEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InterlinkEvent.EventType $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : ((Object)((Object)$eventType)).hashCode());
        String $partition = this.getPartition();
        result = result * 59 + ($partition == null ? 43 : $partition.hashCode());
        ExecutionType $executionType = this.getExecutionType();
        result = result * 59 + ($executionType == null ? 43 : $executionType.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        String $pausedBy = this.getPausedBy();
        result = result * 59 + ($pausedBy == null ? 43 : $pausedBy.hashCode());
        return result;
    }

    public String toString() {
        return "PauseInterlinkEvent(eventType=" + this.getEventType() + ", partition=" + this.getPartition() + ", executionType=" + this.getExecutionType() + ", executionId=" + this.getExecutionId() + ", pausedBy=" + this.getPausedBy() + ")";
    }

    public PauseInterlinkEvent(@Nullable String partition, @NonNull ExecutionType executionType, @NonNull String executionId, @Nullable String pausedBy) {
        if (executionType == null) {
            throw new NullPointerException("executionType is marked non-null but is null");
        }
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        this.partition = partition;
        this.executionType = executionType;
        this.executionId = executionId;
        this.pausedBy = pausedBy;
    }

    public PauseInterlinkEvent() {
    }
}

