/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.interlink.events;

import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.interlink.events.InterlinkEvent;
import com.netflix.spinnaker.orca.pipeline.CompoundExecutionOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RestartStageInterlinkEvent
implements InterlinkEvent {
    final InterlinkEvent.EventType eventType = InterlinkEvent.EventType.RESTART;
    @Nullable
    String partition;
    @Nonnull
    ExecutionType executionType;
    @Nonnull
    String executionId;
    @Nonnull
    String stageId;

    public RestartStageInterlinkEvent(@Nonnull ExecutionType executionType, @Nonnull String executionId, @Nonnull String stageId) {
        this.executionType = executionType;
        this.executionId = executionId;
        this.stageId = stageId;
    }

    @Override
    public void applyTo(CompoundExecutionOperator executionOperator) {
        executionOperator.restartStage(this.executionId, this.stageId);
    }

    @Override
    public InterlinkEvent.EventType getEventType() {
        return this.eventType;
    }

    @Override
    @Nullable
    public String getPartition() {
        return this.partition;
    }

    @Override
    @Nonnull
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    @Nonnull
    public String getExecutionId() {
        return this.executionId;
    }

    @Nonnull
    public String getStageId() {
        return this.stageId;
    }

    @Override
    public void setPartition(@Nullable String partition) {
        this.partition = partition;
    }

    public void setExecutionType(@Nonnull ExecutionType executionType) {
        if (executionType == null) {
            throw new NullPointerException("executionType is marked non-null but is null");
        }
        this.executionType = executionType;
    }

    public void setExecutionId(@Nonnull String executionId) {
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        this.executionId = executionId;
    }

    public void setStageId(@Nonnull String stageId) {
        if (stageId == null) {
            throw new NullPointerException("stageId is marked non-null but is null");
        }
        this.stageId = stageId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestartStageInterlinkEvent)) {
            return false;
        }
        RestartStageInterlinkEvent other = (RestartStageInterlinkEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InterlinkEvent.EventType this$eventType = this.getEventType();
        InterlinkEvent.EventType other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !((Object)((Object)this$eventType)).equals((Object)other$eventType)) {
            return false;
        }
        String this$partition = this.getPartition();
        String other$partition = other.getPartition();
        if (this$partition == null ? other$partition != null : !this$partition.equals(other$partition)) {
            return false;
        }
        ExecutionType this$executionType = this.getExecutionType();
        ExecutionType other$executionType = other.getExecutionType();
        if (this$executionType == null ? other$executionType != null : !this$executionType.equals(other$executionType)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        String this$stageId = this.getStageId();
        String other$stageId = other.getStageId();
        return !(this$stageId == null ? other$stageId != null : !this$stageId.equals(other$stageId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestartStageInterlinkEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InterlinkEvent.EventType $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : ((Object)((Object)$eventType)).hashCode());
        String $partition = this.getPartition();
        result = result * 59 + ($partition == null ? 43 : $partition.hashCode());
        ExecutionType $executionType = this.getExecutionType();
        result = result * 59 + ($executionType == null ? 43 : $executionType.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        String $stageId = this.getStageId();
        result = result * 59 + ($stageId == null ? 43 : $stageId.hashCode());
        return result;
    }

    public String toString() {
        return "RestartStageInterlinkEvent(eventType=" + this.getEventType() + ", partition=" + this.getPartition() + ", executionType=" + this.getExecutionType() + ", executionId=" + this.getExecutionId() + ", stageId=" + this.getStageId() + ")";
    }

    public RestartStageInterlinkEvent(@Nullable String partition, @Nonnull ExecutionType executionType, @Nonnull String executionId, @Nonnull String stageId) {
        if (executionType == null) {
            throw new NullPointerException("executionType is marked non-null but is null");
        }
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        if (stageId == null) {
            throw new NullPointerException("stageId is marked non-null but is null");
        }
        this.partition = partition;
        this.executionType = executionType;
        this.executionId = executionId;
        this.stageId = stageId;
    }

    public RestartStageInterlinkEvent() {
    }
}

