/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.interlink.events;

import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.interlink.events.InterlinkEvent;
import com.netflix.spinnaker.orca.pipeline.CompoundExecutionOperator;
import javax.annotation.Nullable;
import lombok.NonNull;

public class ResumeInterlinkEvent
implements InterlinkEvent {
    final InterlinkEvent.EventType eventType = InterlinkEvent.EventType.RESUME;
    @Nullable
    String partition;
    @NonNull
    ExecutionType executionType;
    @NonNull
    String executionId;
    @Nullable
    String user;
    @NonNull
    Boolean ignoreCurrentStatus;

    public ResumeInterlinkEvent(@NonNull ExecutionType executionType, @NonNull String executionId, @Nullable String user, @NonNull Boolean ignoreCurrentStatus) {
        if (executionType == null) {
            throw new NullPointerException("executionType is marked non-null but is null");
        }
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        if (ignoreCurrentStatus == null) {
            throw new NullPointerException("ignoreCurrentStatus is marked non-null but is null");
        }
        this.executionType = executionType;
        this.executionId = executionId;
        this.user = user;
        this.ignoreCurrentStatus = ignoreCurrentStatus;
    }

    @Override
    public void applyTo(CompoundExecutionOperator executionOperator) {
        executionOperator.resume(this.executionType, this.executionId, this.user, this.ignoreCurrentStatus);
    }

    @Override
    public InterlinkEvent.EventType getEventType() {
        return this.eventType;
    }

    @Override
    @Nullable
    public String getPartition() {
        return this.partition;
    }

    @Override
    @NonNull
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Override
    @NonNull
    public String getExecutionId() {
        return this.executionId;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    @NonNull
    public Boolean getIgnoreCurrentStatus() {
        return this.ignoreCurrentStatus;
    }

    @Override
    public void setPartition(@Nullable String partition) {
        this.partition = partition;
    }

    public void setExecutionType(@NonNull ExecutionType executionType) {
        if (executionType == null) {
            throw new NullPointerException("executionType is marked non-null but is null");
        }
        this.executionType = executionType;
    }

    public void setExecutionId(@NonNull String executionId) {
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        this.executionId = executionId;
    }

    public void setUser(@Nullable String user) {
        this.user = user;
    }

    public void setIgnoreCurrentStatus(@NonNull Boolean ignoreCurrentStatus) {
        if (ignoreCurrentStatus == null) {
            throw new NullPointerException("ignoreCurrentStatus is marked non-null but is null");
        }
        this.ignoreCurrentStatus = ignoreCurrentStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResumeInterlinkEvent)) {
            return false;
        }
        ResumeInterlinkEvent other = (ResumeInterlinkEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$ignoreCurrentStatus = this.getIgnoreCurrentStatus();
        Boolean other$ignoreCurrentStatus = other.getIgnoreCurrentStatus();
        if (this$ignoreCurrentStatus == null ? other$ignoreCurrentStatus != null : !((Object)this$ignoreCurrentStatus).equals(other$ignoreCurrentStatus)) {
            return false;
        }
        InterlinkEvent.EventType this$eventType = this.getEventType();
        InterlinkEvent.EventType other$eventType = other.getEventType();
        if (this$eventType == null ? other$eventType != null : !((Object)((Object)this$eventType)).equals((Object)other$eventType)) {
            return false;
        }
        String this$partition = this.getPartition();
        String other$partition = other.getPartition();
        if (this$partition == null ? other$partition != null : !this$partition.equals(other$partition)) {
            return false;
        }
        ExecutionType this$executionType = this.getExecutionType();
        ExecutionType other$executionType = other.getExecutionType();
        if (this$executionType == null ? other$executionType != null : !this$executionType.equals(other$executionType)) {
            return false;
        }
        String this$executionId = this.getExecutionId();
        String other$executionId = other.getExecutionId();
        if (this$executionId == null ? other$executionId != null : !this$executionId.equals(other$executionId)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        return !(this$user == null ? other$user != null : !this$user.equals(other$user));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResumeInterlinkEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $ignoreCurrentStatus = this.getIgnoreCurrentStatus();
        result = result * 59 + ($ignoreCurrentStatus == null ? 43 : ((Object)$ignoreCurrentStatus).hashCode());
        InterlinkEvent.EventType $eventType = this.getEventType();
        result = result * 59 + ($eventType == null ? 43 : ((Object)((Object)$eventType)).hashCode());
        String $partition = this.getPartition();
        result = result * 59 + ($partition == null ? 43 : $partition.hashCode());
        ExecutionType $executionType = this.getExecutionType();
        result = result * 59 + ($executionType == null ? 43 : $executionType.hashCode());
        String $executionId = this.getExecutionId();
        result = result * 59 + ($executionId == null ? 43 : $executionId.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        return result;
    }

    public String toString() {
        return "ResumeInterlinkEvent(eventType=" + this.getEventType() + ", partition=" + this.getPartition() + ", executionType=" + this.getExecutionType() + ", executionId=" + this.getExecutionId() + ", user=" + this.getUser() + ", ignoreCurrentStatus=" + this.getIgnoreCurrentStatus() + ")";
    }

    public ResumeInterlinkEvent(@Nullable String partition, @NonNull ExecutionType executionType, @NonNull String executionId, @Nullable String user, @NonNull Boolean ignoreCurrentStatus) {
        if (executionType == null) {
            throw new NullPointerException("executionType is marked non-null but is null");
        }
        if (executionId == null) {
            throw new NullPointerException("executionId is marked non-null but is null");
        }
        if (ignoreCurrentStatus == null) {
            throw new NullPointerException("ignoreCurrentStatus is marked non-null but is null");
        }
        this.partition = partition;
        this.executionType = executionType;
        this.executionId = executionId;
        this.user = user;
        this.ignoreCurrentStatus = ignoreCurrentStatus;
    }

    public ResumeInterlinkEvent() {
    }
}

