/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.ext;

import com.netflix.spinnaker.orca.api.pipeline.SyntheticStageOwner;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.TaskExecution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\t\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\b\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\u0004*\u00020\u0002\u001a\u0010\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0002\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\u00022\b\b\u0002\u0010\r\u001a\u00020\f\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0002\u001a\u0010\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0002\u001a\n\u0010\u0012\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0013\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0004*\u00020\u0002\u001a\u001a\u0010\u0016\u001a\u0002H\u0017\"\u0006\b\u0000\u0010\u0017\u0018\u0001*\u00020\u0002H\u0086\b\u00a2\u0006\u0002\u0010\u0018\u001a\"\u0010\u0016\u001a\u0002H\u0017\"\u0006\b\u0000\u0010\u0017\u0018\u0001*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001aH\u0086\b\u00a2\u0006\u0002\u0010\u001b\u001a\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u0011*\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0011\u001a\n\u0010\u001e\u001a\u00020\u0002*\u00020\u0002\u001a\u0010\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0002\u001a\n\u0010 \u001a\u00020\u0004*\u00020\u0002\u001a\u0010\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0002\u001a\u0010\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0002\u00a8\u0006#"}, d2={"afterStages", "", "Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;", "allAfterStagesComplete", "", "allAfterStagesSuccessful", "allBeforeStagesSuccessful", "allUpstreamStagesComplete", "anyAfterStagesFailed", "anyBeforeStagesFailed", "beforeStages", "failureStatus", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionStatus;", "default", "firstAfterStages", "firstBeforeStages", "firstTask", "Lcom/netflix/spinnaker/orca/api/pipeline/models/TaskExecution;", "hasAfterStages", "hasTasks", "isInitial", "isManuallySkipped", "mapTo", "O", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;)Ljava/lang/Object;", "pointer", "", "(Lcom/netflix/spinnaker/orca/api/pipeline/models/StageExecution;Ljava/lang/String;)Ljava/lang/Object;", "nextTask", "task", "parent", "recursiveSyntheticStages", "shouldFailPipeline", "syntheticStages", "upstreamStages", "orca-kotlin"})
public final class StageKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<StageExecution> firstBeforeStages(@NotNull StageExecution $this$firstBeforeStages) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$firstBeforeStages, (String)"<this>");
        Iterable $this$filter$iv = StageKt.beforeStages($this$firstBeforeStages);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StageExecution it = (StageExecution)element$iv$iv;
            boolean bl = false;
            if (!StageKt.isInitial(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<StageExecution> firstAfterStages(@NotNull StageExecution $this$firstAfterStages) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$firstAfterStages, (String)"<this>");
        Iterable $this$filter$iv = StageKt.afterStages($this$firstAfterStages);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StageExecution it = (StageExecution)element$iv$iv;
            boolean bl = false;
            if (!StageKt.isInitial(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isInitial(@NotNull StageExecution $this$isInitial) {
        Intrinsics.checkNotNullParameter((Object)$this$isInitial, (String)"<this>");
        return $this$isInitial.getRequisiteStageRefIds().isEmpty();
    }

    @Nullable
    public static final TaskExecution firstTask(@NotNull StageExecution $this$firstTask) {
        Intrinsics.checkNotNullParameter((Object)$this$firstTask, (String)"<this>");
        List list = $this$firstTask.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tasks");
        return (TaskExecution)CollectionsKt.firstOrNull((List)list);
    }

    @NotNull
    public static final StageExecution parent(@NotNull StageExecution $this$parent) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$parent, (String)"<this>");
            List list = $this$parent.getExecution().getStages();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"execution\n    .stages");
            Iterable iterable = list;
            for (Object t : iterable) {
                StageExecution it = (StageExecution)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)$this$parent.getParentStageId())) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        StageExecution stageExecution = v1;
        if (stageExecution == null) {
            throw new IllegalStateException("Not a synthetic stage");
        }
        return stageExecution;
    }

    @Nullable
    public static final TaskExecution nextTask(@NotNull StageExecution $this$nextTask, @NotNull TaskExecution task) {
        TaskExecution taskExecution;
        Intrinsics.checkNotNullParameter((Object)$this$nextTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (task.isStageEnd()) {
            taskExecution = null;
        } else {
            int index = $this$nextTask.getTasks().indexOf(task);
            taskExecution = (TaskExecution)$this$nextTask.getTasks().get(index + 1);
        }
        return taskExecution;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<StageExecution> upstreamStages(@NotNull StageExecution $this$upstreamStages) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$upstreamStages, (String)"<this>");
        List list = $this$upstreamStages.getExecution().getStages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"execution.stages");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StageExecution it = (StageExecution)element$iv$iv;
            boolean bl = false;
            if (!$this$upstreamStages.getRequisiteStageRefIds().contains(it.getRefId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean allUpstreamStagesComplete(@NotNull StageExecution $this$allUpstreamStagesComplete) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$allUpstreamStagesComplete, (String)"<this>");
            Iterable $this$all$iv = StageKt.upstreamStages($this$allUpstreamStagesComplete);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    StageExecution it = (StageExecution)element$iv;
                    boolean bl2 = false;
                    Object[] objectArray = new ExecutionStatus[]{ExecutionStatus.SUCCEEDED, ExecutionStatus.FAILED_CONTINUE, ExecutionStatus.SKIPPED};
                    if (CollectionsKt.listOf((Object[])objectArray).contains(it.getStatus())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<StageExecution> syntheticStages(@NotNull StageExecution $this$syntheticStages) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$syntheticStages, (String)"<this>");
        List list = $this$syntheticStages.getExecution().getStages();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"execution.stages");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StageExecution it = (StageExecution)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getParentStageId(), (Object)$this$syntheticStages.getId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<StageExecution> recursiveSyntheticStages(@NotNull StageExecution $this$recursiveSyntheticStages) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)$this$recursiveSyntheticStages, (String)"<this>");
        Iterable iterable = StageKt.syntheticStages($this$recursiveSyntheticStages);
        Collection collection = StageKt.syntheticStages($this$recursiveSyntheticStages);
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            StageExecution it = (StageExecution)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = StageKt.recursiveSyntheticStages(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<StageExecution> beforeStages(@NotNull StageExecution $this$beforeStages) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$beforeStages, (String)"<this>");
        Iterable $this$filter$iv = StageKt.syntheticStages($this$beforeStages);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StageExecution it = (StageExecution)element$iv$iv;
            boolean bl = false;
            if (!(it.getSyntheticStageOwner() == SyntheticStageOwner.STAGE_BEFORE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<StageExecution> afterStages(@NotNull StageExecution $this$afterStages) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$afterStages, (String)"<this>");
        Iterable $this$filter$iv = StageKt.syntheticStages($this$afterStages);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StageExecution it = (StageExecution)element$iv$iv;
            boolean bl = false;
            if (!(it.getSyntheticStageOwner() == SyntheticStageOwner.STAGE_AFTER)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean allBeforeStagesSuccessful(@NotNull StageExecution $this$allBeforeStagesSuccessful) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$allBeforeStagesSuccessful, (String)"<this>");
            Iterable $this$all$iv = StageKt.beforeStages($this$allBeforeStagesSuccessful);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    StageExecution it = (StageExecution)element$iv;
                    boolean bl2 = false;
                    Object[] objectArray = new ExecutionStatus[]{ExecutionStatus.SUCCEEDED, ExecutionStatus.FAILED_CONTINUE, ExecutionStatus.SKIPPED};
                    if (CollectionsKt.listOf((Object[])objectArray).contains(it.getStatus())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean allAfterStagesSuccessful(@NotNull StageExecution $this$allAfterStagesSuccessful) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$allAfterStagesSuccessful, (String)"<this>");
            Iterable $this$all$iv = StageKt.afterStages($this$allAfterStagesSuccessful);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    StageExecution it = (StageExecution)element$iv;
                    boolean bl2 = false;
                    Object[] objectArray = new ExecutionStatus[]{ExecutionStatus.SUCCEEDED, ExecutionStatus.FAILED_CONTINUE, ExecutionStatus.SKIPPED};
                    if (CollectionsKt.listOf((Object[])objectArray).contains(it.getStatus())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean anyBeforeStagesFailed(@NotNull StageExecution $this$anyBeforeStagesFailed) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$anyBeforeStagesFailed, (String)"<this>");
            Iterable $this$any$iv = StageKt.beforeStages($this$anyBeforeStagesFailed);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    StageExecution it = (StageExecution)element$iv;
                    boolean bl2 = false;
                    Object[] objectArray = new ExecutionStatus[]{ExecutionStatus.TERMINAL, ExecutionStatus.STOPPED, ExecutionStatus.CANCELED};
                    if (!CollectionsKt.listOf((Object[])objectArray).contains(it.getStatus())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean anyAfterStagesFailed(@NotNull StageExecution $this$anyAfterStagesFailed) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$anyAfterStagesFailed, (String)"<this>");
            Iterable $this$any$iv = StageKt.afterStages($this$anyAfterStagesFailed);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    StageExecution it = (StageExecution)element$iv;
                    boolean bl2 = false;
                    Object[] objectArray = new ExecutionStatus[]{ExecutionStatus.TERMINAL, ExecutionStatus.STOPPED, ExecutionStatus.CANCELED};
                    if (!CollectionsKt.listOf((Object[])objectArray).contains(it.getStatus())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean allAfterStagesComplete(@NotNull StageExecution $this$allAfterStagesComplete) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$allAfterStagesComplete, (String)"<this>");
            Iterable $this$all$iv = StageKt.afterStages($this$allAfterStagesComplete);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    StageExecution it = (StageExecution)element$iv;
                    boolean bl2 = false;
                    if (it.getStatus().isComplete()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean hasTasks(@NotNull StageExecution $this$hasTasks) {
        Intrinsics.checkNotNullParameter((Object)$this$hasTasks, (String)"<this>");
        List list = $this$hasTasks.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tasks");
        return !((Collection)list).isEmpty();
    }

    public static final boolean hasAfterStages(@NotNull StageExecution $this$hasAfterStages) {
        Intrinsics.checkNotNullParameter((Object)$this$hasAfterStages, (String)"<this>");
        return !((Collection)StageKt.firstAfterStages($this$hasAfterStages)).isEmpty();
    }

    public static final /* synthetic */ <O> O mapTo(StageExecution $this$mapTo, String pointer) {
        Intrinsics.checkNotNullParameter((Object)$this$mapTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        boolean $i$f$mapTo = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"O");
        return (O)$this$mapTo.mapTo(pointer, Object.class);
    }

    public static final /* synthetic */ <O> O mapTo(StageExecution $this$mapTo) {
        Intrinsics.checkNotNullParameter((Object)$this$mapTo, (String)"<this>");
        boolean $i$f$mapTo = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"O");
        return (O)$this$mapTo.mapTo(Object.class);
    }

    public static final boolean shouldFailPipeline(@NotNull StageExecution $this$shouldFailPipeline) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldFailPipeline, (String)"<this>");
        Object[] objectArray = new Boolean[]{null, true};
        return CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), $this$shouldFailPipeline.getContext().get("failPipeline"));
    }

    @NotNull
    public static final ExecutionStatus failureStatus(@NotNull StageExecution $this$failureStatus, @NotNull ExecutionStatus executionStatus) {
        Intrinsics.checkNotNullParameter((Object)$this$failureStatus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)executionStatus, (String)"default");
        return $this$failureStatus.getContinuePipelineOnFailure() ? ExecutionStatus.FAILED_CONTINUE : (StageKt.shouldFailPipeline($this$failureStatus) ? executionStatus : ExecutionStatus.STOPPED);
    }

    public static /* synthetic */ ExecutionStatus failureStatus$default(StageExecution stageExecution, ExecutionStatus executionStatus, int n, Object object) {
        if ((n & 1) != 0) {
            executionStatus = ExecutionStatus.TERMINAL;
        }
        return StageKt.failureStatus(stageExecution, executionStatus);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isManuallySkipped(@NotNull StageExecution $this$isManuallySkipped) {
        Intrinsics.checkNotNullParameter((Object)$this$isManuallySkipped, (String)"<this>");
        if (Intrinsics.areEqual($this$isManuallySkipped.getContext().get("manualSkip"), (Object)true)) return true;
        StageExecution stageExecution = $this$isManuallySkipped.getParent();
        if (stageExecution == null) return false;
        if (!StageKt.isManuallySkipped(stageExecution)) return false;
        return true;
    }
}

