/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.mine.pipeline;

import com.netflix.spinnaker.orca.clouddriver.tasks.cluster.PipelineClusterExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class CanaryPipelineClusterExtractor
implements PipelineClusterExtractor {
    public String getStageType() {
        return "canary";
    }

    public void updateStageClusters(Map stage, List<Map> replacements) {
        List clusterPairs = (List)stage.get("clusterPairs");
        clusterPairs.forEach(pair -> {
            pair.put("baseline", replacements.remove(0));
            pair.put("canary", replacements.remove(0));
        });
    }

    public List<Map> extractClusters(Map stage) {
        ArrayList<Map> results = new ArrayList<Map>();
        List clusterPairs = stage.getOrDefault("clusterPairs", new ArrayList());
        clusterPairs.forEach(pair -> {
            results.add((Map)pair.get("baseline"));
            results.add((Map)pair.get("canary"));
        });
        return results;
    }
}

