/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.config.PeeringAgentConfiguration$WhenMappings;
import com.netflix.spinnaker.config.PeeringAgentConfigurationProperties;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.orca.notifications.NotificationClusterLock;
import com.netflix.spinnaker.orca.peering.CustomPeerer;
import com.netflix.spinnaker.orca.peering.ExecutionCopier;
import com.netflix.spinnaker.orca.peering.MySqlRawAccess;
import com.netflix.spinnaker.orca.peering.PeeringAgent;
import com.netflix.spinnaker.orca.peering.PeeringMetrics;
import com.netflix.spinnaker.orca.peering.SqlRawAccess;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.naming.ConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={PeeringAgentConfigurationProperties.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0017\u00a8\u0006\u0011"}, d2={"Lcom/netflix/spinnaker/config/PeeringAgentConfiguration;", "", "()V", "peeringAgent", "Lcom/netflix/spinnaker/orca/peering/PeeringAgent;", "jooq", "Lorg/jooq/DSLContext;", "clusterLock", "Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;", "dynamicConfigService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "registry", "Lcom/netflix/spectator/api/Registry;", "properties", "Lcom/netflix/spinnaker/config/PeeringAgentConfigurationProperties;", "customPeerer", "Lcom/netflix/spinnaker/orca/peering/CustomPeerer;", "orca-peering"})
public class PeeringAgentConfiguration {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Bean
    @ConditionalOnExpression(value="${pollers.peering.enabled:false}")
    @NotNull
    public PeeringAgent peeringAgent(@NotNull DSLContext jooq, @NotNull NotificationClusterLock clusterLock, @NotNull DynamicConfigService dynamicConfigService, @NotNull Registry registry, @NotNull PeeringAgentConfigurationProperties properties, @Nullable CustomPeerer customPeerer) {
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)clusterLock, (String)"clusterLock");
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        if (properties.getPeerId() == null || properties.getPoolName() == null) {
            throw (Throwable)new ConfigurationException("pollers.peering.id and pollers.peering.poolName must be specified for peering");
        }
        ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat(PeeringAgent.class.getSimpleName() + '-' + properties.getPeerId() + "-%d").build());
        SqlRawAccess sourceDB = null;
        SqlRawAccess destinationDB = null;
        SQLDialect sQLDialect = jooq.dialect();
        if (sQLDialect == null) throw (Throwable)new UnsupportedOperationException("Peering only supported on MySQL right now");
        switch (PeeringAgentConfiguration$WhenMappings.$EnumSwitchMapping$0[sQLDialect.ordinal()]) {
            case 1: {
                String string = properties.getPoolName();
                Intrinsics.checkNotNull((Object)string);
                sourceDB = new MySqlRawAccess(jooq, string, properties.getChunkSize());
                destinationDB = new MySqlRawAccess(jooq, "default", properties.getChunkSize());
                break;
            }
            default: {
                throw (Throwable)new UnsupportedOperationException("Peering only supported on MySQL right now");
            }
        }
        String string = properties.getPeerId();
        Intrinsics.checkNotNull((Object)string);
        PeeringMetrics metrics = new PeeringMetrics(string, registry);
        String string2 = properties.getPeerId();
        Intrinsics.checkNotNull((Object)string2);
        ExecutorService executorService = executor;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"executor");
        ExecutionCopier copier = new ExecutionCopier(string2, sourceDB, destinationDB, executorService, properties.getThreadCount(), properties.getChunkSize(), metrics);
        String string3 = properties.getPeerId();
        Intrinsics.checkNotNull((Object)string3);
        return new PeeringAgent(string3, properties.getIntervalMs(), properties.getClockDriftMs(), sourceDB, destinationDB, dynamicConfigService, metrics, copier, customPeerer, clusterLock);
    }
}

