/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.peering;

import com.netflix.spinnaker.kork.exceptions.SystemException;
import com.netflix.spinnaker.kork.sql.routing.NamedDatabaseContextHolder;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.peering.MySqlRawAccess$sam$java_util_function_Supplier$0;
import com.netflix.spinnaker.orca.peering.SqlRawAccess;
import com.netflix.spinnaker.orca.peering.UtilsKt;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.vavr.control.Try;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.InsertValuesStepN;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u0016J(\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000f2\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\u0006\u0010\f\u001a\u00020\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\f\u001a\u00020\r2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u001e\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J!\u0010&\u001a\u0002H'\"\u0004\b\u0000\u0010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)H\u0002\u00a2\u0006\u0002\u0010*R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/netflix/spinnaker/orca/peering/MySqlRawAccess;", "Lcom/netflix/spinnaker/orca/peering/SqlRawAccess;", "jooq", "Lorg/jooq/DSLContext;", "poolName", "", "chunkSize", "", "(Lorg/jooq/DSLContext;Ljava/lang/String;I)V", "maxPacketSize", "", "deleteExecutions", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "pipelineIdsToDelete", "", "deleteStages", "", "stageIdsToDelete", "getActiveExecutionIds", "partitionName", "getCompletedExecutionIds", "Lcom/netflix/spinnaker/orca/peering/SqlRawAccess$ExecutionDiffKey;", "updatedAfter", "getDeletedExecutions", "Lcom/netflix/spinnaker/orca/peering/SqlRawAccess$DeletedExecution;", "sinceCursor", "getExecutions", "Lorg/jooq/Result;", "Lorg/jooq/Record;", "ids", "getStageIdsForExecutions", "executionIds", "getStages", "stageIds", "loadRecords", "tableName", "records", "withRetry", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "orca-peering"})
public class MySqlRawAccess
extends SqlRawAccess {
    private long maxPacketSize;

    @Override
    @NotNull
    public List<SqlRawAccess.ExecutionDiffKey> getCompletedExecutionIds(@NotNull ExecutionType executionType, @Nullable String partitionName, long updatedAfter) {
        Condition condition;
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        if (partitionName == null) {
            Field field = DSL.field((String)"`partition`");
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field(\"`partition`\")");
            condition = field.isNull();
        } else {
            condition = DSL.field((String)"`partition`").eq((Object)partitionName);
        }
        Condition partitionConstraint = condition;
        Object t = this.withRetry((Function0)new Function0<List<SqlRawAccess.ExecutionDiffKey>>(this, executionType, updatedAfter, partitionConstraint){
            final /* synthetic */ MySqlRawAccess this$0;
            final /* synthetic */ ExecutionType $executionType;
            final /* synthetic */ long $updatedAfter;
            final /* synthetic */ Condition $partitionConstraint;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final List<SqlRawAccess.ExecutionDiffKey> invoke() {
                List list;
                String name$iv = this.this$0.getPoolName();
                boolean $i$f$withPool = false;
                NamedDatabaseContextHolder.INSTANCE.set(name$iv);
                try {
                    boolean bl = false;
                    Collection $this$toTypedArray$iv = this.this$0.getCompletedStatuses();
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    list = this.this$0.getJooq().select((SelectField)DSL.field((String)"id"), (SelectField)DSL.field((String)"updated_at")).from((TableLike)UtilsKt.getExecutionTable(this.$executionType)).where(DSL.field((String)"status").in((Object[])Arrays.copyOf(stringArray, stringArray.length)).and(DSL.field((String)"updated_at").gt((Object)this.$updatedAfter)).and(this.$partitionConstraint)).fetchInto(SqlRawAccess.ExecutionDiffKey.class);
                }
                finally {
                    NamedDatabaseContextHolder.INSTANCE.clear();
                }
                return list;
            }
            {
                this.this$0 = mySqlRawAccess;
                this.$executionType = executionType;
                this.$updatedAfter = l;
                this.$partitionConstraint = condition;
                super(0);
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, (String)"withRetry {\n      withPo\u2026class.java)\n      }\n    }");
        return (List)t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<String> getActiveExecutionIds(@NotNull ExecutionType executionType, @Nullable String partitionName) {
        List list;
        Condition condition;
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        if (partitionName == null) {
            Field field = DSL.field((String)"`partition`");
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field(\"`partition`\")");
            condition = field.isNull();
        } else {
            condition = DSL.field((String)"`partition`").eq((Object)partitionName);
        }
        Condition partitionConstraint = condition;
        String name$iv = this.getPoolName();
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            Collection $this$toTypedArray$iv = this.getActiveStatuses();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            List list2 = this.getJooq().select((SelectField)DSL.field((String)"id")).from((TableLike)UtilsKt.getExecutionTable(executionType)).where(DSL.field((String)"status").in((Object[])Arrays.copyOf(stringArray, stringArray.length)).and(partitionConstraint)).fetch(DSL.field((String)"id"), String.class);
            list = list2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"withPool(poolName) {\n   \u2026String::class.java)\n    }");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<SqlRawAccess.DeletedExecution> getDeletedExecutions(int sinceCursor) {
        List list;
        String name$iv = this.getPoolName();
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            List list2 = this.getJooq().select((SelectField)DSL.field((String)"id"), (SelectField)DSL.field((String)"execution_id"), (SelectField)DSL.field((String)"execution_type")).from((TableLike)DSL.table((String)"deleted_executions")).where(DSL.field((String)"id").gt((Object)sinceCursor)).fetchInto(SqlRawAccess.DeletedExecution.class);
            list = list2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"withPool(poolName) {\n   \u2026cution::class.java)\n    }");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<SqlRawAccess.ExecutionDiffKey> getStageIdsForExecutions(@NotNull ExecutionType executionType, @NotNull List<String> executionIds) {
        List list;
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter(executionIds, (String)"executionIds");
        String name$iv = this.getPoolName();
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            Collection $this$toTypedArray$iv = executionIds;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            List list2 = this.getJooq().select((SelectField)DSL.field((String)"id"), (SelectField)DSL.field((String)"updated_at")).from((TableLike)UtilsKt.getStagesTable(executionType)).where(DSL.field((String)"execution_id").in((Object[])Arrays.copyOf(stringArray, stringArray.length))).fetchInto(SqlRawAccess.ExecutionDiffKey.class);
            list = list2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"withPool(poolName) {\n   \u2026iffKey::class.java)\n    }");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Result<Record> getExecutions(@NotNull ExecutionType executionType, @NotNull List<String> ids) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        String name$iv = this.getPoolName();
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            Collection $this$toTypedArray$iv = ids;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Result result2 = this.getJooq().select(new SelectFieldOrAsterisk[]{(SelectFieldOrAsterisk)DSL.asterisk()}).from((TableLike)UtilsKt.getExecutionTable(executionType)).where(DSL.field((String)"id").in((Object[])Arrays.copyOf(stringArray, stringArray.length))).fetch();
            result = result2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"withPool(poolName) {\n   \u2026))\n        .fetch()\n    }");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Result<Record> getStages(@NotNull ExecutionType executionType, @NotNull List<String> stageIds) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter(stageIds, (String)"stageIds");
        String name$iv = this.getPoolName();
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            Collection $this$toTypedArray$iv = stageIds;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Result result2 = this.getJooq().select(new SelectFieldOrAsterisk[]{(SelectFieldOrAsterisk)DSL.asterisk()}).from((TableLike)UtilsKt.getStagesTable(executionType)).where(DSL.field((String)"id").in((Object[])Arrays.copyOf(stringArray, stringArray.length))).fetch();
            result = result2;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"withPool(poolName) {\n   \u2026))\n        .fetch()\n    }");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteStages(@NotNull ExecutionType executionType, @NotNull List<String> stageIdsToDelete) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter(stageIdsToDelete, (String)"stageIdsToDelete");
        String name$iv = this.getPoolName();
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl = false;
            for (List chunk : CollectionsKt.chunked((Iterable)stageIdsToDelete, (int)this.getChunkSize())) {
                Collection $this$toTypedArray$iv = chunk;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                this.getJooq().deleteFrom(UtilsKt.getStagesTable(executionType)).where(DSL.field((String)"id").in((Object[])Arrays.copyOf(stringArray, stringArray.length))).execute();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteExecutions(@NotNull ExecutionType executionType, @NotNull List<String> pipelineIdsToDelete) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter(pipelineIdsToDelete, (String)"pipelineIdsToDelete");
        int countDeleted = 0;
        if (pipelineIdsToDelete.isEmpty()) {
            return countDeleted;
        }
        int n = this.getChunkSize();
        int n2 = 5;
        boolean bl = false;
        int deleteChunkSize = Math.min(n, n2);
        String name$iv = this.getPoolName();
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            boolean bl2 = false;
            for (List chunk : CollectionsKt.chunked((Iterable)pipelineIdsToDelete, (int)this.getChunkSize())) {
                Collection $this$toTypedArray$iv = chunk;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                this.getJooq().deleteFrom(UtilsKt.getStagesTable(executionType)).where(DSL.field((String)"execution_id").in((Object[])Arrays.copyOf(stringArray, stringArray.length))).execute();
                $this$toTypedArray$iv = chunk;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                if (stringArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                countDeleted += this.getJooq().deleteFrom(UtilsKt.getExecutionTable(executionType)).where(DSL.field((String)"id").in((Object[])Arrays.copyOf(stringArray2, stringArray2.length))).execute();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return countDeleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public int loadRecords(@NotNull String tableName, @NotNull Result<Record> records) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter(records, (String)"records");
        if (records.isEmpty()) {
            return 0;
        }
        Object[] objectArray = ((Record)records.get(0)).fields();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"records[0].fields()");
        List allFields = ArraysKt.toList((Object[])objectArray);
        int persisted = 0;
        String name$iv = this.getPoolName();
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(name$iv);
        try {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = allFields;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Field field = (Field)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                Pair pair = TuplesKt.to((Object)it, (Object)DSL.field((String)"VALUES({0})", (DataType)v1.getDataType(), (QueryPart[])new QueryPart[]{(QueryPart)it}));
                collection.add(pair);
            }
            Map updateSet = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            int cumulativeSize = 0;
            InsertValuesStepN batchQuery = this.getJooq().insertInto(DSL.table((String)tableName)).columns((Collection)allFields);
            Iterable $this$forEach$iv = (Iterable)records;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int n;
                void $this$sumBy$iv;
                Record it = (Record)element$iv;
                boolean bl3 = false;
                List values = it.intoList();
                int n2 = 3 * values.size();
                List list = values;
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"values");
                Iterable iterable2 = list;
                int n3 = n2;
                boolean $i$f$sumBy = false;
                int sum$iv = 0;
                Iterator iterator = $this$sumBy$iv.iterator();
                while (iterator.hasNext()) {
                    void value;
                    Object element$iv2;
                    Object t = element$iv2 = iterator.next();
                    n = sum$iv;
                    boolean bl4 = false;
                    String string = value;
                    int n4 = string != null && (string = string.toString()) != null ? string.length() : 4;
                    sum$iv = n + n4;
                }
                n = sum$iv;
                int totalRecordSize = n3 + n;
                if ((long)(cumulativeSize + totalRecordSize) > this.maxPacketSize) {
                    if (cumulativeSize == 0) {
                        throw (Throwable)new SystemException("Can't persist a single row for table " + tableName + " due to maxPacketSize restriction. Row size = " + totalRecordSize);
                    }
                    persisted += batchQuery.onDuplicateKeyUpdate().set(updateSet).execute();
                    batchQuery = this.getJooq().insertInto(DSL.table((String)tableName)).columns((Collection)allFields).values((Collection)values);
                    cumulativeSize = 0;
                } else {
                    batchQuery = batchQuery.values((Collection)values);
                }
                cumulativeSize += totalRecordSize;
            }
            if (cumulativeSize > 0) {
                persisted += batchQuery.onDuplicateKeyUpdate().set(updateSet).execute();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        return persisted;
    }

    private final <T> T withRetry(Function0<? extends T> action) {
        Retry retry = Retry.of((String)"sqlPeeringAgent", (RetryConfig)RetryConfig.custom().maxAttempts(3).waitDuration(Duration.ofMillis(500L)).build());
        Object object = action;
        if (object != null) {
            Function0<? extends T> function0 = object;
            object = new MySqlRawAccess$sam$java_util_function_Supplier$0(function0);
        }
        return (T)Try.ofSupplier((Supplier)Retry.decorateSupplier((Retry)retry, (Supplier)((Supplier)object))).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MySqlRawAccess(@NotNull DSLContext jooq, @NotNull String poolName, int chunkSize) {
        long l;
        long l2;
        Intrinsics.checkNotNullParameter((Object)jooq, (String)"jooq");
        Intrinsics.checkNotNullParameter((Object)poolName, (String)"poolName");
        super(jooq, poolName, chunkSize);
        MySqlRawAccess mySqlRawAccess = this;
        boolean $i$f$withPool = false;
        NamedDatabaseContextHolder.INSTANCE.set(poolName);
        try {
            boolean bl = false;
            Long l3 = (Long)jooq.resultQuery("SHOW VARIABLES WHERE Variable_name='max_allowed_packet'").fetchSingle(DSL.field((String)"Value"), Long.TYPE);
            l2 = l3 != null ? l3 : 0L;
        }
        finally {
            NamedDatabaseContextHolder.INSTANCE.clear();
        }
        mySqlRawAccess.maxPacketSize = l = l2;
        this.getLog().info("Initialized MySqlRawAccess with pool=" + poolName + " and maxPacketSize=" + this.maxPacketSize);
        this.maxPacketSize -= (long)8192;
    }
}

