/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.peering;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.peering.ExecutionState;
import com.netflix.spinnaker.orca.peering.PeeringMetricsKt;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\u00020\u00102\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100$H\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/netflix/spinnaker/orca/peering/PeeringMetrics;", "", "peeredId", "", "registry", "Lcom/netflix/spectator/api/Registry;", "(Ljava/lang/String;Lcom/netflix/spectator/api/Registry;)V", "peeringCustomPeererNumErrorsId", "Lcom/netflix/spectator/api/Id;", "kotlin.jvm.PlatformType", "peeringLagTimerId", "peeringNumDeletedId", "peeringNumErrorsId", "peeringNumPeeredId", "peeringNumStagesDeletedId", "incrementCustomPeererError", "", "peererName", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "incrementNumDeleted", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "count", "", "incrementNumErrors", "incrementNumPeered", "state", "Lcom/netflix/spinnaker/orca/peering/ExecutionState;", "incrementNumStagesDeleted", "recordLag", "duration", "Ljava/time/Duration;", "recordOverallLag", "block", "Lkotlin/Function0;", "orca-peering"})
public class PeeringMetrics {
    private final Id peeringLagTimerId;
    private final Id peeringNumPeeredId;
    private final Id peeringNumDeletedId;
    private final Id peeringNumStagesDeletedId;
    private final Id peeringNumErrorsId;
    private final Id peeringCustomPeererNumErrorsId;
    private final Registry registry;

    public void recordOverallLag(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.registry.timer(this.peeringLagTimerId.withTag("executionType", "OVER_ALL")).record(new Runnable(block){
            final /* synthetic */ Function0 $block;

            public final void run() {
                this.$block.invoke();
            }
            {
                this.$block = function0;
            }
        });
    }

    public void recordLag(@NotNull ExecutionType executionType, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Id id = this.peeringLagTimerId;
        Intrinsics.checkNotNullExpressionValue((Object)id, (String)"peeringLagTimerId");
        this.registry.timer(PeeringMetricsKt.tag(id, executionType)).record(duration);
    }

    public void incrementNumPeered(@NotNull ExecutionType executionType, @NotNull ExecutionState state, int count) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Id id = this.peeringNumPeeredId;
        Intrinsics.checkNotNullExpressionValue((Object)id, (String)"peeringNumPeeredId");
        this.registry.counter(PeeringMetricsKt.tag(id, executionType, state)).increment((long)count);
    }

    public void incrementNumDeleted(@NotNull ExecutionType executionType, int count) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Id id = this.peeringNumDeletedId;
        Intrinsics.checkNotNullExpressionValue((Object)id, (String)"peeringNumDeletedId");
        this.registry.counter(PeeringMetricsKt.tag(id, executionType)).increment((long)count);
    }

    public void incrementNumErrors(@NotNull ExecutionType executionType) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Id id = this.peeringNumErrorsId;
        Intrinsics.checkNotNullExpressionValue((Object)id, (String)"peeringNumErrorsId");
        this.registry.counter(PeeringMetricsKt.tag(id, executionType)).increment();
    }

    public void incrementNumStagesDeleted(@NotNull ExecutionType executionType, int count) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Id id = this.peeringNumStagesDeletedId;
        Intrinsics.checkNotNullExpressionValue((Object)id, (String)"peeringNumStagesDeletedId");
        this.registry.counter(PeeringMetricsKt.tag(id, executionType)).increment((long)count);
    }

    public void incrementCustomPeererError(@NotNull String peererName, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)peererName, (String)"peererName");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.registry.counter(this.peeringCustomPeererNumErrorsId.withTags("peerer", peererName, "exception", exception.getClass().getSimpleName())).increment();
    }

    public PeeringMetrics(@NotNull String peeredId, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)peeredId, (String)"peeredId");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.registry = registry;
        this.peeringLagTimerId = this.registry.createId("pollers.peering.lag").withTag("peerId", peeredId);
        this.peeringNumPeeredId = this.registry.createId("pollers.peering.numPeered").withTag("peerId", peeredId);
        this.peeringNumDeletedId = this.registry.createId("pollers.peering.numDeleted").withTag("peerId", peeredId);
        this.peeringNumStagesDeletedId = this.registry.createId("pollers.peering.numStagesDeleted").withTag("peerId", peeredId);
        this.peeringNumErrorsId = this.registry.createId("pollers.peering.numErrors").withTag("peerId", peeredId);
        this.peeringCustomPeererNumErrorsId = this.registry.createId("pollers.peering.customPeerer.numErrors").withTag("peerId", peeredId);
    }
}

