/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.peering;

import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.peering.ExecutionState;
import com.netflix.spinnaker.orca.peering.PeeringMetrics;
import com.netflix.spinnaker.orca.peering.SqlRawAccess;
import com.netflix.spinnaker.orca.peering.UtilsKt;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001bB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J&\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/netflix/spinnaker/orca/peering/ExecutionCopier;", "", "peeredId", "", "srcDB", "Lcom/netflix/spinnaker/orca/peering/SqlRawAccess;", "destDB", "executor", "Ljava/util/concurrent/ExecutorService;", "threadCount", "", "chunkSize", "peeringMetrics", "Lcom/netflix/spinnaker/orca/peering/PeeringMetrics;", "(Ljava/lang/String;Lcom/netflix/spinnaker/orca/peering/SqlRawAccess;Lcom/netflix/spinnaker/orca/peering/SqlRawAccess;Ljava/util/concurrent/ExecutorService;IILcom/netflix/spinnaker/orca/peering/PeeringMetrics;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "copyExecutionChunk", "Lcom/netflix/spinnaker/orca/peering/ExecutionCopier$MigrationChunkResult;", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "idsToMigrate", "", "state", "Lcom/netflix/spinnaker/orca/peering/ExecutionState;", "copyInParallel", "MigrationChunkResult", "orca-peering"})
public class ExecutionCopier {
    private final Logger log;
    private final String peeredId;
    private final SqlRawAccess srcDB;
    private final SqlRawAccess destDB;
    private final ExecutorService executor;
    private final int threadCount;
    private final int chunkSize;
    private final PeeringMetrics peeringMetrics;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MigrationChunkResult copyInParallel(@NotNull ExecutionType executionType, @NotNull List<String> idsToMigrate, @NotNull ExecutionState state) {
        Intrinsics.checkNotNullParameter((Object)executionType, (String)"executionType");
        Intrinsics.checkNotNullParameter(idsToMigrate, (String)"idsToMigrate");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue(CollectionsKt.chunked((Iterable)idsToMigrate, (int)this.chunkSize));
        Instant startTime = Instant.now();
        AtomicInteger migratedCount = new AtomicInteger(0);
        int n = this.threadCount;
        int n2 = queue.size();
        boolean bl = false;
        int effectiveThreadCount = Math.min(n, n2);
        this.log.info("Kicking off migration with (chunk size: " + this.chunkSize + ", threadCount: " + effectiveThreadCount + ')');
        n2 = 0;
        ArrayList arrayList = new ArrayList(effectiveThreadCount);
        boolean bl2 = false;
        int n3 = 0;
        n3 = 0;
        int n4 = effectiveThreadCount;
        while (n3 < n4) {
            Future future;
            void threadIndex;
            int n5 = n3++;
            boolean bl3 = false;
            int n6 = n5;
            ArrayList arrayList2 = arrayList;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue(this.executor.submit((Callable)new Callable<MigrationChunkResult>((int)threadIndex, this, queue, executionType, state, migratedCount, startTime, idsToMigrate){
                final /* synthetic */ int $threadIndex;
                final /* synthetic */ ExecutionCopier this$0;
                final /* synthetic */ ConcurrentLinkedQueue $queue$inlined;
                final /* synthetic */ ExecutionType $executionType$inlined;
                final /* synthetic */ ExecutionState $state$inlined;
                final /* synthetic */ AtomicInteger $migratedCount$inlined;
                final /* synthetic */ Instant $startTime$inlined;
                final /* synthetic */ List $idsToMigrate$inlined;
                {
                    this.$threadIndex = n;
                    this.this$0 = executionCopier;
                    this.$queue$inlined = concurrentLinkedQueue;
                    this.$executionType$inlined = executionType;
                    this.$state$inlined = executionState;
                    this.$migratedCount$inlined = atomicInteger;
                    this.$startTime$inlined = instant;
                    this.$idsToMigrate$inlined = list;
                }

                public final MigrationChunkResult call() {
                    long latestUpdatedAt = 0L;
                    boolean hadErrors = false;
                    while ((List)this.$queue$inlined.poll() != null) {
                        List chunkToProcess;
                        MigrationChunkResult result = ExecutionCopier.access$copyExecutionChunk(this.this$0, this.$executionType$inlined, chunkToProcess, this.$state$inlined);
                        hadErrors = hadErrors || result.getHadErrors();
                        int migrated = this.$migratedCount$inlined.addAndGet(result.getCount());
                        long l = result.getLatestUpdatedAt();
                        boolean bl = false;
                        latestUpdatedAt = Math.max(latestUpdatedAt, l);
                        if (this.$threadIndex != 0) continue;
                        long elapsedTime = Duration.between(this.$startTime$inlined, Instant.now()).toMillis();
                        long etaMillis = (long)((double)this.$idsToMigrate$inlined.size() / (double)migrated * (double)elapsedTime - (double)elapsedTime);
                        ExecutionCopier.access$getLog$p(this.this$0).info("Migrated " + migrated + " of " + this.$idsToMigrate$inlined.size() + ", ETA: " + Duration.ofMillis(etaMillis));
                    }
                    return new MigrationChunkResult(latestUpdatedAt, 0, hadErrors);
                }
            }), (String)"executor.submit(\n       \u2026Errors)\n        }\n      )");
            arrayList2.add(future);
        }
        List futures = arrayList;
        long latestUpdatedAt = 0L;
        boolean hadErrors = false;
        for (Future future : futures) {
            MigrationChunkResult singleResult = (MigrationChunkResult)future.get();
            hadErrors = hadErrors || singleResult.getHadErrors();
            long l = singleResult.getLatestUpdatedAt();
            boolean bl5 = false;
            latestUpdatedAt = Math.max(latestUpdatedAt, l);
        }
        return new MigrationChunkResult(latestUpdatedAt, migratedCount.get(), hadErrors);
    }

    /*
     * WARNING - void declaration
     */
    private final MigrationChunkResult copyExecutionChunk(ExecutionType executionType, List<String> idsToMigrate, ExecutionState state) {
        long latestUpdatedAt = 0L;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void $this$filterTo$iv$iv2;
            void $this$mapTo$iv$iv3;
            String string;
            Collection collection;
            void $this$mapTo$iv$iv4;
            Result<Record> executionRows = this.srcDB.getExecutions(executionType, idsToMigrate);
            List<SqlRawAccess.ExecutionDiffKey> stagesInSource = this.srcDB.getStageIdsForExecutions(executionType, idsToMigrate);
            Iterable $this$map$iv3 = stagesInSource;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv3;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                Iterator it;
                SqlRawAccess.ExecutionDiffKey executionDiffKey = (SqlRawAccess.ExecutionDiffKey)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                string = ((SqlRawAccess.ExecutionDiffKey)((Object)it)).getId();
                collection.add(string);
            }
            HashSet stagesInSourceHash = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            List<SqlRawAccess.ExecutionDiffKey> stagesInDest = this.destDB.getStageIdsForExecutions(executionType, idsToMigrate);
            Iterable $this$map$iv4 = stagesInDest;
            boolean $i$f$map2 = false;
            Iterable $i$f$mapTo22 = $this$map$iv4;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                SqlRawAccess.ExecutionDiffKey executionDiffKey = (SqlRawAccess.ExecutionDiffKey)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                string = TuplesKt.to((Object)it.getId(), (Object)it);
                collection.add(string);
            }
            Map stagesInDestMap = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            Iterable $this$filter$iv2 = stagesInDest;
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                SqlRawAccess.ExecutionDiffKey it = (SqlRawAccess.ExecutionDiffKey)element$iv$iv;
                boolean bl = false;
                if (!(!stagesInSourceHash.contains(it.getId()))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv3;
            boolean $i$f$map222 = false;
            $this$filterTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                SqlRawAccess.ExecutionDiffKey it = (SqlRawAccess.ExecutionDiffKey)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl = false;
                string = it.getId();
                collection.add(string);
            }
            List stageIdsToDelete = (List)destination$iv$iv3;
            if (CollectionsKt.any((Iterable)stageIdsToDelete)) {
                this.destDB.deleteStages(executionType, stageIdsToDelete);
                this.peeringMetrics.incrementNumStagesDeleted(executionType, stageIdsToDelete.size());
            }
            Iterable $i$f$map222 = stagesInSource;
            boolean $i$f$filter2 = false;
            destination$iv$iv3 = $this$filter$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SqlRawAccess.ExecutionDiffKey key = (SqlRawAccess.ExecutionDiffKey)element$iv$iv;
                boolean bl = false;
                SqlRawAccess.ExecutionDiffKey executionDiffKey = (SqlRawAccess.ExecutionDiffKey)stagesInDestMap.get(key.getId());
                if (!((executionDiffKey != null ? executionDiffKey.getUpdated_at() : 0L) < key.getUpdated_at())) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv4;
            boolean $i$f$map3 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SqlRawAccess.ExecutionDiffKey key = (SqlRawAccess.ExecutionDiffKey)item$iv$iv;
                collection = destination$iv$iv4;
                boolean bl = false;
                string = it.getId();
                collection.add(string);
            }
            List stageIdsToMigrate = (List)destination$iv$iv4;
            for (List chunk : CollectionsKt.chunked((Iterable)stageIdsToMigrate, (int)this.chunkSize)) {
                Result<Record> stageRows = this.srcDB.getStages(executionType, chunk);
                String string2 = UtilsKt.getStagesTable(executionType).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStagesTable(executionType).name");
                this.destDB.loadRecords(string2, stageRows);
            }
            Iterable $this$forEach$iv = (Iterable)executionRows;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Record r = (Record)element$iv;
                boolean bl = false;
                r.set(DSL.field((Name)DSL.name((String)"partition")), (Object)this.peeredId);
                long l = latestUpdatedAt;
                Object object = r.get("updated_at", Long.TYPE);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"r.get(\"updated_at\", Long::class.java)");
                long l2 = ((Number)object).longValue();
                boolean bl2 = false;
                latestUpdatedAt = Math.max(l, l2);
            }
            String string3 = UtilsKt.getExecutionTable(executionType).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getExecutionTable(executionType).name");
            this.destDB.loadRecords(string3, executionRows);
            this.peeringMetrics.incrementNumPeered(executionType, state, idsToMigrate.size());
            return new MigrationChunkResult(latestUpdatedAt, idsToMigrate.size(), false);
        }
        catch (Exception e) {
            this.log.error("Failed to peer " + executionType + " chunk (first id: " + idsToMigrate.get(0) + ')', (Throwable)e);
            this.peeringMetrics.incrementNumErrors(executionType);
            return new MigrationChunkResult(0L, 0, true);
        }
    }

    public ExecutionCopier(@NotNull String peeredId, @NotNull SqlRawAccess srcDB, @NotNull SqlRawAccess destDB, @NotNull ExecutorService executor, int threadCount, int chunkSize, @NotNull PeeringMetrics peeringMetrics) {
        Intrinsics.checkNotNullParameter((Object)peeredId, (String)"peeredId");
        Intrinsics.checkNotNullParameter((Object)srcDB, (String)"srcDB");
        Intrinsics.checkNotNullParameter((Object)destDB, (String)"destDB");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)peeringMetrics, (String)"peeringMetrics");
        this.peeredId = peeredId;
        this.srcDB = srcDB;
        this.destDB = destDB;
        this.executor = executor;
        this.threadCount = threadCount;
        this.chunkSize = chunkSize;
        this.peeringMetrics = peeringMetrics;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public static final /* synthetic */ MigrationChunkResult access$copyExecutionChunk(ExecutionCopier $this, ExecutionType executionType, List idsToMigrate, ExecutionState state) {
        return $this.copyExecutionChunk(executionType, idsToMigrate, state);
    }

    public static final /* synthetic */ Logger access$getLog$p(ExecutionCopier $this) {
        return $this.log;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/netflix/spinnaker/orca/peering/ExecutionCopier$MigrationChunkResult;", "", "latestUpdatedAt", "", "count", "", "hadErrors", "", "(JIZ)V", "getCount", "()I", "getHadErrors", "()Z", "getLatestUpdatedAt", "()J", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "orca-peering"})
    public static final class MigrationChunkResult {
        private final long latestUpdatedAt;
        private final int count;
        private final boolean hadErrors;

        public final long getLatestUpdatedAt() {
            return this.latestUpdatedAt;
        }

        public final int getCount() {
            return this.count;
        }

        public final boolean getHadErrors() {
            return this.hadErrors;
        }

        public MigrationChunkResult(long latestUpdatedAt, int count, boolean hadErrors) {
            this.latestUpdatedAt = latestUpdatedAt;
            this.count = count;
            this.hadErrors = hadErrors;
        }

        public /* synthetic */ MigrationChunkResult(long l, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            this(l, n, bl);
        }

        public final long component1() {
            return this.latestUpdatedAt;
        }

        public final int component2() {
            return this.count;
        }

        public final boolean component3() {
            return this.hadErrors;
        }

        @NotNull
        public final MigrationChunkResult copy(long latestUpdatedAt, int count, boolean hadErrors) {
            return new MigrationChunkResult(latestUpdatedAt, count, hadErrors);
        }

        public static /* synthetic */ MigrationChunkResult copy$default(MigrationChunkResult migrationChunkResult, long l, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = migrationChunkResult.latestUpdatedAt;
            }
            if ((n2 & 2) != 0) {
                n = migrationChunkResult.count;
            }
            if ((n2 & 4) != 0) {
                bl = migrationChunkResult.hadErrors;
            }
            return migrationChunkResult.copy(l, n, bl);
        }

        @NotNull
        public String toString() {
            return "MigrationChunkResult(latestUpdatedAt=" + this.latestUpdatedAt + ", count=" + this.count + ", hadErrors=" + this.hadErrors + ")";
        }

        public int hashCode() {
            int n = (Long.hashCode(this.latestUpdatedAt) * 31 + Integer.hashCode(this.count)) * 31;
            int n2 = this.hadErrors ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MigrationChunkResult)) break block3;
                    MigrationChunkResult migrationChunkResult = (MigrationChunkResult)object;
                    if (this.latestUpdatedAt != migrationChunkResult.latestUpdatedAt || this.count != migrationChunkResult.count || this.hadErrors != migrationChunkResult.hadErrors) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

