/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.peering;

import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.notifications.AbstractPollingNotificationAgent;
import com.netflix.spinnaker.orca.notifications.NotificationClusterLock;
import com.netflix.spinnaker.orca.peering.CustomPeerer;
import com.netflix.spinnaker.orca.peering.ExecutionCopier;
import com.netflix.spinnaker.orca.peering.ExecutionState;
import com.netflix.spinnaker.orca.peering.PeeringAgent$WhenMappings;
import com.netflix.spinnaker.orca.peering.PeeringMetrics;
import com.netflix.spinnaker.orca.peering.SqlRawAccess;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001-BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030!H\u0002J\u0018\u0010\"\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u0005H\u0002J\b\u0010$\u001a\u00020\u0003H\u0014J\b\u0010%\u001a\u00020\u0005H\u0014J\b\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010)\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010*\u001a\u00020'H\u0002J\u0010\u0010+\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010,\u001a\u00020'H\u0014R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/netflix/spinnaker/orca/peering/PeeringAgent;", "Lcom/netflix/spinnaker/orca/notifications/AbstractPollingNotificationAgent;", "peeredId", "", "pollingIntervalMs", "", "clockDriftMs", "srcDB", "Lcom/netflix/spinnaker/orca/peering/SqlRawAccess;", "destDB", "dynamicConfigService", "Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;", "peeringMetrics", "Lcom/netflix/spinnaker/orca/peering/PeeringMetrics;", "executionCopier", "Lcom/netflix/spinnaker/orca/peering/ExecutionCopier;", "customPeerer", "Lcom/netflix/spinnaker/orca/peering/CustomPeerer;", "clusterLock", "Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;", "(Ljava/lang/String;JJLcom/netflix/spinnaker/orca/peering/SqlRawAccess;Lcom/netflix/spinnaker/orca/peering/SqlRawAccess;Lcom/netflix/spinnaker/kork/dynamicconfig/DynamicConfigService;Lcom/netflix/spinnaker/orca/peering/PeeringMetrics;Lcom/netflix/spinnaker/orca/peering/ExecutionCopier;Lcom/netflix/spinnaker/orca/peering/CustomPeerer;Lcom/netflix/spinnaker/orca/notifications/NotificationClusterLock;)V", "completedOrchestrationsMostRecentUpdatedTime", "completedPipelinesMostRecentUpdatedTime", "deletedExecutionCursor", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "delete", "Lcom/netflix/spinnaker/orca/peering/PeeringAgent$DeletionResult;", "executionType", "Lcom/netflix/spinnaker/orca/api/pipeline/models/ExecutionType;", "idsToDelete", "", "doMigrate", "updatedAfter", "getNotificationType", "getPollingInterval", "invokeCustomPeerer", "", "peerActiveExecutions", "peerCompletedExecutions", "peerDeletedExecutions", "peerExecutions", "tick", "DeletionResult", "orca-peering"})
public final class PeeringAgent
extends AbstractPollingNotificationAgent {
    private final Logger log;
    private final CustomPeerer customPeerer;
    private long completedPipelinesMostRecentUpdatedTime;
    private long completedOrchestrationsMostRecentUpdatedTime;
    private int deletedExecutionCursor;
    private final String peeredId;
    private final long pollingIntervalMs;
    private final long clockDriftMs;
    private final SqlRawAccess srcDB;
    private final SqlRawAccess destDB;
    private final DynamicConfigService dynamicConfigService;
    private final PeeringMetrics peeringMetrics;
    private final ExecutionCopier executionCopier;

    protected void tick() {
        if (this.dynamicConfigService.isEnabled("pollers.peering", true) && this.dynamicConfigService.isEnabled("pollers.peering." + this.peeredId, true)) {
            this.peeringMetrics.recordOverallLag((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ PeeringAgent this$0;

                public final void invoke() {
                    PeeringAgent.access$peerExecutions(this.this$0, ExecutionType.PIPELINE);
                    PeeringAgent.access$peerExecutions(this.this$0, ExecutionType.ORCHESTRATION);
                    PeeringAgent.access$peerDeletedExecutions(this.this$0);
                    PeeringAgent.access$invokeCustomPeerer(this.this$0);
                }
                {
                    this.this$0 = peeringAgent;
                    super(0);
                }
            }));
        }
    }

    private final void peerExecutions(ExecutionType executionType) {
        try {
            boolean isFirstRun;
            long l;
            Instant start = Instant.now();
            switch (PeeringAgent$WhenMappings.$EnumSwitchMapping$0[executionType.ordinal()]) {
                case 1: {
                    l = this.completedOrchestrationsMostRecentUpdatedTime;
                    break;
                }
                case 2: {
                    l = this.completedPipelinesMostRecentUpdatedTime;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            long mostRecentUpdatedTime = l;
            boolean bl = isFirstRun = mostRecentUpdatedTime == 0L;
            if (isFirstRun) {
                this.peerCompletedExecutions(executionType);
            } else {
                this.peerCompletedExecutions(executionType);
                this.peerActiveExecutions(executionType);
            }
            Duration duration = Duration.between(start, Instant.now());
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.between(start, Instant.now())");
            this.peeringMetrics.recordLag(executionType, duration);
        }
        catch (Exception e) {
            this.log.error("Failed to peer " + executionType, (Throwable)e);
            this.peeringMetrics.incrementNumErrors(executionType);
        }
    }

    private final void peerActiveExecutions(ExecutionType executionType) {
        this.log.debug("Starting active " + executionType + " copy for peering");
        List activePipelineIds = CollectionsKt.plus((Collection)this.srcDB.getActiveExecutionIds(executionType, this.peeredId), (Iterable)this.srcDB.getActiveExecutionIds(executionType, null));
        Collection collection = activePipelineIds;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.log.debug("Found " + activePipelineIds.size() + " active " + executionType + ", copying all");
            ExecutionCopier.MigrationChunkResult migrationResult = this.executionCopier.copyInParallel(executionType, activePipelineIds, ExecutionState.ACTIVE);
            if (migrationResult.getHadErrors()) {
                this.log.error("Finished active " + executionType + " peering: copied " + migrationResult.getCount() + " of " + activePipelineIds.size() + " with errors, see prior log statements");
            } else {
                this.log.debug("Finished active " + executionType + " peering: copied " + migrationResult.getCount() + " of " + activePipelineIds.size());
            }
        } else {
            this.log.debug("No active " + executionType + " executions to copy for peering");
        }
    }

    private final void peerCompletedExecutions(ExecutionType executionType) {
        long l;
        switch (PeeringAgent$WhenMappings.$EnumSwitchMapping$1[executionType.ordinal()]) {
            case 1: {
                l = this.completedOrchestrationsMostRecentUpdatedTime;
                break;
            }
            case 2: {
                l = this.completedPipelinesMostRecentUpdatedTime;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        long updatedAfter = l;
        this.log.debug("Starting completed " + executionType + " copy for peering with " + executionType + " updatedAfter=" + updatedAfter);
        long newLatestUpdateTime = this.doMigrate(executionType, updatedAfter) - this.clockDriftMs;
        if (executionType == ExecutionType.ORCHESTRATION) {
            this.completedOrchestrationsMostRecentUpdatedTime = RangesKt.coerceAtLeast((long)newLatestUpdateTime, (long)0L);
        } else {
            this.completedPipelinesMostRecentUpdatedTime = RangesKt.coerceAtLeast((long)newLatestUpdateTime, (long)0L);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void peerDeletedExecutions() {
        try {
            boolean succeeded;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            String string;
            Object object;
            void $this$mapTo$iv$iv2;
            SqlRawAccess.DeletedExecution it;
            Iterable $this$filterTo$iv$iv2;
            List<SqlRawAccess.DeletedExecution> deletedExecutionIds = this.srcDB.getDeletedExecutions(this.deletedExecutionCursor);
            Iterable $this$filter$iv = deletedExecutionIds;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (SqlRawAccess.DeletedExecution)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getExecution_type(), (Object)ExecutionType.ORCHESTRATION.toString())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv2 = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (SqlRawAccess.DeletedExecution)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                string = it.getExecution_id();
                object.add(string);
            }
            List orchestrationIdsToDelete = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = deletedExecutionIds;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SqlRawAccess.DeletedExecution it2 = (SqlRawAccess.DeletedExecution)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it2.getExecution_type(), (Object)ExecutionType.PIPELINE.toString())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                SqlRawAccess.DeletedExecution it2 = (SqlRawAccess.DeletedExecution)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                string = it2.getExecution_id();
                object.add(string);
            }
            List pipelineIdsToDelete = (List)destination$iv$iv2;
            this.log.debug("Found " + deletedExecutionIds.size() + " (orchestrations: " + orchestrationIdsToDelete.size() + " pipelines: " + pipelineIdsToDelete.size() + " deleted candidates after cursor: " + this.deletedExecutionCursor);
            DeletionResult orchestrationDeletionResult = this.delete(ExecutionType.ORCHESTRATION, orchestrationIdsToDelete);
            DeletionResult pipelinesDeletionResult = this.delete(ExecutionType.PIPELINE, pipelineIdsToDelete);
            boolean bl = succeeded = !orchestrationDeletionResult.getHadFailures() && !pipelinesDeletionResult.getHadFailures();
            if (succeeded) {
                Object v1;
                void $this$maxBy$iv;
                destination$iv$iv2 = deletedExecutionIds;
                object = this;
                boolean $i$f$maxBy = false;
                void $this$maxByOrNull$iv$iv = $this$maxBy$iv;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv$iv = $this$maxByOrNull$iv$iv.iterator();
                if (!iterator$iv$iv.hasNext()) {
                    v1 = null;
                } else {
                    Object maxElem$iv$iv = iterator$iv$iv.next();
                    if (!iterator$iv$iv.hasNext()) {
                        v1 = maxElem$iv$iv;
                    } else {
                        SqlRawAccess.DeletedExecution it3 = (SqlRawAccess.DeletedExecution)maxElem$iv$iv;
                        boolean bl2 = false;
                        int maxValue$iv$iv = it3.getId();
                        do {
                            Object e$iv$iv = iterator$iv$iv.next();
                            SqlRawAccess.DeletedExecution it4 = (SqlRawAccess.DeletedExecution)e$iv$iv;
                            $i$a$-maxBy-PeeringAgent$peerDeletedExecutions$1 = false;
                            int v$iv$iv = it4.getId();
                            if (maxValue$iv$iv >= v$iv$iv) continue;
                            maxElem$iv$iv = e$iv$iv;
                            maxValue$iv$iv = v$iv$iv;
                        } while (iterator$iv$iv.hasNext());
                        v1 = maxElem$iv$iv;
                    }
                }
                string = v1;
                SqlRawAccess.DeletedExecution deletedExecution = (SqlRawAccess.DeletedExecution)((Object)string);
                ((PeeringAgent)((Object)object)).deletedExecutionCursor = deletedExecution != null ? deletedExecution.getId() : this.deletedExecutionCursor;
                this.log.debug("Deleted orchestrations: " + orchestrationDeletionResult.getNumDeleted() + " (of " + orchestrationIdsToDelete.size() + " requested), pipelines: " + pipelinesDeletionResult.getNumDeleted() + " (of " + pipelineIdsToDelete.size() + " requested), new cursor: " + this.deletedExecutionCursor);
            } else {
                this.log.error("Failed to delete some executions, not updating the cursor location to retry next time");
            }
        }
        catch (Exception e) {
            this.log.error("Failed to delete some executions", (Throwable)e);
            this.peeringMetrics.incrementNumErrors(ExecutionType.ORCHESTRATION);
            this.peeringMetrics.incrementNumErrors(ExecutionType.PIPELINE);
        }
    }

    private final void invokeCustomPeerer() {
        if (this.customPeerer != null) {
            String peererName = this.customPeerer.getClass().getSimpleName();
            try {
                this.log.info("Starting peering with custom peerer '" + peererName + '\'');
                boolean peeringSuccess = this.customPeerer.doPeer();
                if (peeringSuccess) {
                    this.log.info("Completed peering with custom peerer '" + peererName + '\'');
                } else {
                    this.log.error("Completed peering with custom peerer '" + peererName + "' with errors");
                }
            }
            catch (Exception e) {
                String string = peererName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"peererName");
                this.peeringMetrics.incrementCustomPeererError(string, e);
                this.log.error("Custom peerer '" + peererName + "' failed", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final long doMigrate(ExecutionType executionType, long updatedAfter) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv2;
        void $this$mapTo$iv$iv3;
        void $this$map$iv3;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv4;
        void $this$map$iv4;
        List completedPipelineKeys = CollectionsKt.plus((Collection)this.srcDB.getCompletedExecutionIds(executionType, this.peeredId, updatedAfter), (Iterable)this.srcDB.getCompletedExecutionIds(executionType, null, updatedAfter));
        List<SqlRawAccess.ExecutionDiffKey> migratedPipelineKeys = this.destDB.getCompletedExecutionIds(executionType, this.peeredId, updatedAfter);
        Iterable iterable = completedPipelineKeys;
        boolean $i$f$map22 = false;
        void var9_8 = $this$map$iv4;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            void it;
            SqlRawAccess.ExecutionDiffKey executionDiffKey = (SqlRawAccess.ExecutionDiffKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = TuplesKt.to((Object)it.getId(), (Object)it);
            collection.add(object);
        }
        Map completedPipelineKeysMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Iterable $i$f$map22 = migratedPipelineKeys;
        boolean $i$f$map32 = false;
        destination$iv$iv = $this$map$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            SqlRawAccess.ExecutionDiffKey bl = (SqlRawAccess.ExecutionDiffKey)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            object = TuplesKt.to((Object)it.getId(), (Object)it);
            collection.add(object);
        }
        Map migratedPipelineKeysMap = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        Iterable $i$f$map32 = completedPipelineKeys;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            SqlRawAccess.ExecutionDiffKey key = (SqlRawAccess.ExecutionDiffKey)element$iv$iv;
            boolean bl = false;
            SqlRawAccess.ExecutionDiffKey executionDiffKey = (SqlRawAccess.ExecutionDiffKey)migratedPipelineKeysMap.get(key.getId());
            if (!((executionDiffKey != null ? executionDiffKey.getUpdated_at() : 0L) < key.getUpdated_at())) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv3;
        boolean $i$f$map42 = false;
        $this$filterTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            SqlRawAccess.ExecutionDiffKey key = (SqlRawAccess.ExecutionDiffKey)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            object = it.getId();
            collection.add(object);
        }
        List pipelineIdsToMigrate = (List)destination$iv$iv3;
        Iterable $i$f$map42 = migratedPipelineKeys;
        boolean $i$f$filter2 = false;
        destination$iv$iv3 = $this$filter$iv;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SqlRawAccess.ExecutionDiffKey key = (SqlRawAccess.ExecutionDiffKey)element$iv$iv;
            boolean bl = false;
            if (!(!completedPipelineKeysMap.containsKey(key.getId()))) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv4;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SqlRawAccess.ExecutionDiffKey key = (SqlRawAccess.ExecutionDiffKey)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            object = it.getId();
            collection.add(object);
        }
        List pipelineIdsToDelete = (List)destination$iv$iv4;
        var $fun$getLatestCompletedUpdatedTime$1 = new Function0<Long>(completedPipelineKeys, updatedAfter){
            final /* synthetic */ List $completedPipelineKeys;
            final /* synthetic */ long $updatedAfter;

            /*
             * WARNING - void declaration
             */
            public final long invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$completedPipelineKeys;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SqlRawAccess.ExecutionDiffKey executionDiffKey = (SqlRawAccess.ExecutionDiffKey)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Long l = it.getUpdated_at();
                    collection.add(l);
                }
                Long l = (Long)CollectionsKt.max((Iterable)((List)destination$iv$iv));
                return l != null ? l : this.$updatedAfter;
            }
            {
                this.$completedPipelineKeys = list;
                this.$updatedAfter = l;
                super(0);
            }
        };
        if (pipelineIdsToDelete.isEmpty() && pipelineIdsToMigrate.isEmpty()) {
            this.log.debug("No completed " + executionType + " executions to copy for peering");
            return $fun$getLatestCompletedUpdatedTime$1.invoke();
        }
        this.log.debug("Found " + completedPipelineKeys.size() + " completed " + executionType + " candidates with " + migratedPipelineKeys.size() + " already copied for peering, " + pipelineIdsToMigrate.size() + " still need copying and " + pipelineIdsToDelete.size() + " need to be deleted");
        Integer maxDeleteCount = (Integer)this.dynamicConfigService.getConfig(Integer.class, "pollers.peering.max-allowed-delete-count", (Object)new Integer(100));
        int actualDeleted = 0;
        if (pipelineIdsToDelete.size() > maxDeleteCount) {
            this.log.error("Number of pipelines to delete (" + pipelineIdsToDelete.size() + ") > threshold (" + maxDeleteCount + ") - not performing deletes - if this is expected you can set the pollers.peering.max-allowed-delete-count property to a larger number");
            this.peeringMetrics.incrementNumErrors(executionType);
        } else if (CollectionsKt.any((Iterable)pipelineIdsToDelete)) {
            actualDeleted = this.destDB.deleteExecutions(executionType, pipelineIdsToDelete);
            this.peeringMetrics.incrementNumDeleted(executionType, actualDeleted);
        }
        if (!CollectionsKt.any((Iterable)pipelineIdsToMigrate)) {
            this.log.debug("Finished completed " + executionType + " peering: nothing to copy, " + actualDeleted + " deleted");
            return $fun$getLatestCompletedUpdatedTime$1.invoke();
        }
        ExecutionCopier.MigrationChunkResult migrationResult = this.executionCopier.copyInParallel(executionType, pipelineIdsToMigrate, ExecutionState.COMPLETED);
        if (migrationResult.getHadErrors()) {
            this.log.error("Finished completed " + executionType + " peering: copied " + migrationResult.getCount() + " of " + pipelineIdsToMigrate.size() + " (deleted " + actualDeleted + ") with errors, see prior log statements");
            return updatedAfter;
        }
        this.log.debug("Finished completed " + executionType + " peering: copied " + migrationResult.getCount() + " of " + pipelineIdsToMigrate.size() + " (deleted " + actualDeleted + ") with latest updatedAt=" + migrationResult.getLatestUpdatedAt());
        return migrationResult.getLatestUpdatedAt();
    }

    private final DeletionResult delete(ExecutionType executionType, List<String> idsToDelete) {
        int numDeleted = 0;
        boolean hadFailures = false;
        try {
            numDeleted = this.destDB.deleteExecutions(executionType, idsToDelete);
            this.peeringMetrics.incrementNumDeleted(executionType, numDeleted);
        }
        catch (Exception e) {
            this.log.error("Failed to delete some " + executionType, (Throwable)e);
            this.peeringMetrics.incrementNumErrors(executionType);
            hadFailures = true;
        }
        return new DeletionResult(numDeleted, hadFailures);
    }

    protected long getPollingInterval() {
        return this.pollingIntervalMs;
    }

    @NotNull
    protected String getNotificationType() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.javaClass.simpleName");
        return string;
    }

    public PeeringAgent(@NotNull String peeredId, long pollingIntervalMs, long clockDriftMs, @NotNull SqlRawAccess srcDB, @NotNull SqlRawAccess destDB, @NotNull DynamicConfigService dynamicConfigService, @NotNull PeeringMetrics peeringMetrics, @NotNull ExecutionCopier executionCopier, @Nullable CustomPeerer customPeerer, @NotNull NotificationClusterLock clusterLock) {
        Intrinsics.checkNotNullParameter((Object)peeredId, (String)"peeredId");
        Intrinsics.checkNotNullParameter((Object)srcDB, (String)"srcDB");
        Intrinsics.checkNotNullParameter((Object)destDB, (String)"destDB");
        Intrinsics.checkNotNullParameter((Object)dynamicConfigService, (String)"dynamicConfigService");
        Intrinsics.checkNotNullParameter((Object)peeringMetrics, (String)"peeringMetrics");
        Intrinsics.checkNotNullParameter((Object)executionCopier, (String)"executionCopier");
        Intrinsics.checkNotNullParameter((Object)clusterLock, (String)"clusterLock");
        super(clusterLock);
        this.peeredId = peeredId;
        this.pollingIntervalMs = pollingIntervalMs;
        this.clockDriftMs = clockDriftMs;
        this.srcDB = srcDB;
        this.destDB = destDB;
        this.dynamicConfigService = dynamicConfigService;
        this.peeringMetrics = peeringMetrics;
        this.executionCopier = executionCopier;
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        boolean initSuccess = false;
        if (customPeerer != null) {
            try {
                customPeerer.init(this.srcDB, this.destDB, this.peeredId);
                initSuccess = true;
            }
            catch (Exception e) {
                String string = customPeerer.getClass().getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"customPeerer.javaClass.simpleName");
                this.peeringMetrics.incrementCustomPeererError(string, e);
                this.log.error("Failed to initialize custom peerer '" + customPeerer.getClass().getSimpleName() + "' - this peerer will not be called", (Throwable)e);
            }
        }
        this.customPeerer = initSuccess ? customPeerer : null;
    }

    public static final /* synthetic */ void access$peerExecutions(PeeringAgent $this, ExecutionType executionType) {
        $this.peerExecutions(executionType);
    }

    public static final /* synthetic */ void access$peerDeletedExecutions(PeeringAgent $this) {
        $this.peerDeletedExecutions();
    }

    public static final /* synthetic */ void access$invokeCustomPeerer(PeeringAgent $this) {
        $this.invokeCustomPeerer();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/netflix/spinnaker/orca/peering/PeeringAgent$DeletionResult;", "", "numDeleted", "", "hadFailures", "", "(IZ)V", "getHadFailures", "()Z", "getNumDeleted", "()I", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "orca-peering"})
    private static final class DeletionResult {
        private final int numDeleted;
        private final boolean hadFailures;

        public final int getNumDeleted() {
            return this.numDeleted;
        }

        public final boolean getHadFailures() {
            return this.hadFailures;
        }

        public DeletionResult(int numDeleted, boolean hadFailures) {
            this.numDeleted = numDeleted;
            this.hadFailures = hadFailures;
        }

        public final int component1() {
            return this.numDeleted;
        }

        public final boolean component2() {
            return this.hadFailures;
        }

        @NotNull
        public final DeletionResult copy(int numDeleted, boolean hadFailures) {
            return new DeletionResult(numDeleted, hadFailures);
        }

        public static /* synthetic */ DeletionResult copy$default(DeletionResult deletionResult, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = deletionResult.numDeleted;
            }
            if ((n2 & 2) != 0) {
                bl = deletionResult.hadFailures;
            }
            return deletionResult.copy(n, bl);
        }

        @NotNull
        public String toString() {
            return "DeletionResult(numDeleted=" + this.numDeleted + ", hadFailures=" + this.hadFailures + ")";
        }

        public int hashCode() {
            int n = Integer.hashCode(this.numDeleted) * 31;
            int n2 = this.hadFailures ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DeletionResult)) break block3;
                    DeletionResult deletionResult = (DeletionResult)object;
                    if (this.numDeleted != deletionResult.numDeleted || this.hadFailures != deletionResult.hadFailures) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

