/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.orca.api.pipeline.ExecutionPreprocessor;
import com.netflix.spinnaker.orca.pipelinetemplate.IrrecoverableConditionException;
import com.netflix.spinnaker.orca.pipelinetemplate.TemplatedPipelineRequest;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.PipelineMissingTemplateVariabledException;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.DefaultHandlerChain;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.GlobalPipelineTemplateContext;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.Handler;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.PipelineTemplateContext;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.PipelineTemplateErrorHandler;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.SchemaVersionHandler;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component(value="pipelineTemplatePreprocessor")
@Order(value=2)
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0017J(\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0012J(\u0010\u001c\u001a\u00020\u001b2\u0014\b\u0001\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\u000f0\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/netflix/spinnaker/orca/pipelinetemplate/PipelineTemplatePreprocessor;", "Lcom/netflix/spinnaker/orca/api/pipeline/ExecutionPreprocessor;", "pipelineTemplateObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "schemaVersionHandler", "Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/SchemaVersionHandler;", "errorHandler", "Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/PipelineTemplateErrorHandler;", "registry", "Lcom/netflix/spectator/api/Registry;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/SchemaVersionHandler;Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/PipelineTemplateErrorHandler;Lcom/netflix/spectator/api/Registry;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "requestsId", "Lcom/netflix/spectator/api/Id;", "confirmUsage", "", "process", "", "", "", "pipeline", "recordRequest", "context", "Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/PipelineTemplateContext;", "success", "", "supports", "execution", "type", "Lcom/netflix/spinnaker/orca/api/pipeline/ExecutionPreprocessor$Type;", "orca-pipelinetemplate"})
public class PipelineTemplatePreprocessor
implements ExecutionPreprocessor {
    private final Logger log;
    private final Id requestsId;
    private final ObjectMapper pipelineTemplateObjectMapper;
    private final SchemaVersionHandler schemaVersionHandler;
    private final PipelineTemplateErrorHandler errorHandler;
    private final Registry registry;

    @PostConstruct
    public void confirmUsage() {
        this.log.info("Using " + this.getClass().getSimpleName());
    }

    public boolean supports(@Nonnull @NotNull Map<String, Object> execution, @Nonnull @NotNull ExecutionPreprocessor.Type type) {
        Intrinsics.checkNotNullParameter(execution, (String)"execution");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return true;
    }

    @NotNull
    public Map<String, Object> process(@NotNull Map<String, Object> pipeline) {
        TemplatedPipelineRequest request;
        Intrinsics.checkNotNullParameter(pipeline, (String)"pipeline");
        Map<String, Object> map = pipeline;
        String string = "schema";
        Object v = null;
        boolean bl = false;
        if (Intrinsics.areEqual(map.getOrDefault(string, v), (Object)"v2") && pipeline.get("template") != null) {
            HashMap<String, Object> templateConfig = new HashMap<String, Object>(pipeline);
            templateConfig.remove("trigger");
            pipeline.put("config", templateConfig);
            pipeline.put("type", "templatedPipeline");
        }
        TemplatedPipelineRequest templatedPipelineRequest = request = (TemplatedPipelineRequest)this.pipelineTemplateObjectMapper.convertValue(pipeline, TemplatedPipelineRequest.class);
        Intrinsics.checkNotNullExpressionValue((Object)templatedPipelineRequest, (String)"request");
        if (!templatedPipelineRequest.isTemplatedPipelineRequest()) {
            return pipeline;
        }
        DefaultHandlerChain chain = new DefaultHandlerChain();
        GlobalPipelineTemplateContext context = new GlobalPipelineTemplateContext(chain, request);
        chain.add(this.schemaVersionHandler);
        while (!chain.isEmpty()) {
            Handler handler = chain.removeFirst();
            try {
                handler.handle(chain, context);
            }
            catch (Throwable t) {
                if (handler instanceof PipelineTemplateErrorHandler) {
                    this.recordRequest(context, false);
                    throw (Throwable)new IrrecoverableConditionException(t);
                }
                if (!(t instanceof PipelineMissingTemplateVariabledException)) {
                    this.log.error("Unexpected error occurred while processing template: ", (Object)context.getRequest().getId(), (Object)t);
                }
                context.getCaughtThrowables().add(t);
                chain.clear();
            }
            if (!chain.isEmpty() || handler instanceof PipelineTemplateErrorHandler) continue;
            chain.add(this.errorHandler);
        }
        this.recordRequest(context, !context.getErrors().hasErrors(false));
        return context.getProcessedOutput();
    }

    private void recordRequest(PipelineTemplateContext context, boolean success) {
        Object[] objectArray = new BasicTag[3];
        objectArray[0] = new BasicTag("status", success ? "success" : "failure");
        String string = context.getRequest().schema;
        if (string == null) {
            string = "unknown";
        }
        objectArray[1] = new BasicTag("schema", string);
        objectArray[2] = new BasicTag("plan", String.valueOf(context.getRequest().plan));
        this.registry.counter(this.requestsId.withTags((Iterable)CollectionsKt.listOf((Object[])objectArray))).increment();
    }

    @Autowired
    public PipelineTemplatePreprocessor(@NotNull ObjectMapper pipelineTemplateObjectMapper, @NotNull SchemaVersionHandler schemaVersionHandler, @NotNull PipelineTemplateErrorHandler errorHandler, @NotNull Registry registry) {
        Intrinsics.checkNotNullParameter((Object)pipelineTemplateObjectMapper, (String)"pipelineTemplateObjectMapper");
        Intrinsics.checkNotNullParameter((Object)schemaVersionHandler, (String)"schemaVersionHandler");
        Intrinsics.checkNotNullParameter((Object)errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        this.pipelineTemplateObjectMapper = pipelineTemplateObjectMapper;
        this.schemaVersionHandler = schemaVersionHandler;
        this.errorHandler = errorHandler;
        this.registry = registry;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.requestsId = this.registry.createId("mpt.requests");
    }
}

