/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionType;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.jackson.OrcaObjectMapper;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionNotFoundException;
import com.netflix.spinnaker.orca.pipeline.persistence.ExecutionRepository;
import com.netflix.spinnaker.orca.pipelinetemplate.loader.TemplateLoader;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.TemplateMerge;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateConfiguration;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.DefaultRenderContext;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.render.Renderer;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PipelineTemplateService {
    private final TemplateLoader templateLoader;
    private final ExecutionRepository executionRepository;
    private final Renderer renderer;
    private final ObjectMapper mapper = OrcaObjectMapper.getInstance();

    @Autowired
    public PipelineTemplateService(TemplateLoader templateLoader, ExecutionRepository executionRepository, Renderer renderer) {
        this.templateLoader = templateLoader;
        this.executionRepository = executionRepository;
        this.renderer = renderer;
    }

    public PipelineTemplate resolveTemplate(TemplateConfiguration.TemplateSource templateSource, @Nullable String executionId, @Nullable String pipelineConfigId) {
        if (PipelineTemplateService.containsJinja(templateSource.getSource()) && (executionId != null || pipelineConfigId != null)) {
            try {
                PipelineExecution pipeline = this.retrievePipelineOrNewestExecution(executionId, pipelineConfigId);
                String renderedSource = this.render(templateSource.getSource(), pipeline);
                if (StringUtils.isNotBlank((CharSequence)renderedSource)) {
                    templateSource.setSource(renderedSource);
                }
            }
            catch (NoSuchElementException pipeline) {
                // empty catch block
            }
        }
        List<PipelineTemplate> templates = this.templateLoader.load(templateSource);
        return TemplateMerge.merge(templates);
    }

    public PipelineExecution retrievePipelineOrNewestExecution(@Nullable String executionId, @Nullable String pipelineConfigId) throws ExecutionNotFoundException {
        if (executionId != null) {
            return this.executionRepository.retrieve(ExecutionType.PIPELINE, executionId);
        }
        if (pipelineConfigId != null) {
            ExecutionRepository.ExecutionCriteria criteria = new ExecutionRepository.ExecutionCriteria().setPageSize(1);
            try {
                return (PipelineExecution)this.executionRepository.retrievePipelinesForPipelineConfigId(pipelineConfigId, criteria).toSingle().toBlocking().value();
            }
            catch (NoSuchElementException e) {
                throw new ExecutionNotFoundException("No pipeline execution could be found for config id " + pipelineConfigId + ": " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("Either executionId or pipelineConfigId have to be set.");
    }

    private String render(String templateString, PipelineExecution pipeline) {
        DefaultRenderContext rc = new DefaultRenderContext(pipeline.getApplication(), null, (Map)this.mapper.convertValue((Object)pipeline.getTrigger(), Map.class));
        return this.renderer.render(templateString, rc);
    }

    private static boolean containsJinja(String string) {
        return string.contains("{%") || string.contains("{{");
    }
}

