/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.handler;

import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.IllegalTemplateConfigurationException;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateLoaderException;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateRenderException;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.Handler;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.HandlerChain;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.PipelineTemplateContext;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.Errors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0012J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/PipelineTemplateErrorHandler;", "Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/Handler;", "()V", "generateErrors", "Lcom/netflix/spinnaker/orca/pipelinetemplate/validator/Errors;", "t", "", "handle", "", "chain", "Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/HandlerChain;", "context", "Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/PipelineTemplateContext;", "orca-pipelinetemplate"})
public class PipelineTemplateErrorHandler
implements Handler {
    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(@NotNull HandlerChain chain, @NotNull PipelineTemplateContext context) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$map$iv = context.getCaughtThrowables();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Throwable throwable = (Throwable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Errors errors = this.generateErrors((Throwable)it);
            collection.add(errors);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Errors it = (Errors)element$iv;
            boolean bl = false;
            context.getErrors().addAll(it);
        }
        Errors errors = context.getErrors();
        Boolean bl = context.getRequest().getPlan();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"context.getRequest().plan");
        if (errors.hasErrors(bl)) {
            Map<String, Object> map = context.getProcessedOutput();
            Map<String, Object> map2 = context.getErrors().toResponse();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"context.getErrors().toResponse()");
            map.putAll(map2);
        }
    }

    private Errors generateErrors(Throwable t) {
        Errors e = new Errors();
        if (t instanceof TemplateLoaderException) {
            if (((TemplateLoaderException)((Object)t)).getErrors().hasErrors(true)) {
                e.addAll(((TemplateLoaderException)((Object)t)).getErrors());
            } else {
                e.add(new Errors.Error().withMessage("failed loading template").withCause(t.getMessage()));
            }
        } else if (t instanceof TemplateRenderException) {
            if (!((TemplateRenderException)((Object)t)).getErrors().hasErrors(true)) {
                e.add(new Errors.Error().withMessage("failed rendering template expression").withCause(t.getMessage()));
            } else {
                e.addAll(((TemplateRenderException)((Object)t)).getErrors());
            }
        } else if (t instanceof IllegalTemplateConfigurationException) {
            e.add(((IllegalTemplateConfigurationException)((Object)t)).getError() != null ? ((IllegalTemplateConfigurationException)((Object)t)).getError() : new Errors.Error().withMessage("malformed template configuration").withCause(t.getMessage()));
        } else {
            e.add(new Errors.Error().withMessage("unexpected error").withCause(t.toString()));
        }
        return e;
    }
}

