/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.handler;

import com.netflix.spinnaker.orca.pipelinetemplate.handler.Handler;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.HandlerChain;
import com.netflix.spinnaker.orca.pipelinetemplate.handler.PipelineTemplateContext;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.handler.V1SchemaHandlerGroup;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.handler.v2.V2SchemaHandlerGroup;
import com.netflix.spinnaker.orca.pipelinetemplate.validator.Errors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/SchemaVersionHandler;", "Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/Handler;", "v1SchemaHandlerGroup", "Lcom/netflix/spinnaker/orca/pipelinetemplate/v1schema/handler/V1SchemaHandlerGroup;", "v2SchemaHandlerGroup", "Lcom/netflix/spinnaker/orca/pipelinetemplate/v1schema/handler/v2/V2SchemaHandlerGroup;", "(Lcom/netflix/spinnaker/orca/pipelinetemplate/v1schema/handler/V1SchemaHandlerGroup;Lcom/netflix/spinnaker/orca/pipelinetemplate/v1schema/handler/v2/V2SchemaHandlerGroup;)V", "handle", "", "chain", "Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/HandlerChain;", "context", "Lcom/netflix/spinnaker/orca/pipelinetemplate/handler/PipelineTemplateContext;", "orca-pipelinetemplate"})
public class SchemaVersionHandler
implements Handler {
    private final V1SchemaHandlerGroup v1SchemaHandlerGroup;
    private final V2SchemaHandlerGroup v2SchemaHandlerGroup;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handle(@NotNull HandlerChain chain, @NotNull PipelineTemplateContext context) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = context.getRequest().getSchema();
        if (string != null) {
            switch (string) {
                case "1": {
                    chain.add(this.v1SchemaHandlerGroup);
                    return;
                }
                case "v2": {
                    chain.add(this.v2SchemaHandlerGroup);
                    return;
                }
            }
        }
        context.getErrors().add(new Errors.Error().withMessage("unexpected schema version '" + context.getRequest().getSchema() + '\''));
    }

    @Autowired
    public SchemaVersionHandler(@NotNull V1SchemaHandlerGroup v1SchemaHandlerGroup, @NotNull V2SchemaHandlerGroup v2SchemaHandlerGroup) {
        Intrinsics.checkNotNullParameter((Object)v1SchemaHandlerGroup, (String)"v1SchemaHandlerGroup");
        Intrinsics.checkNotNullParameter((Object)v2SchemaHandlerGroup, (String)"v2SchemaHandlerGroup");
        this.v1SchemaHandlerGroup = v1SchemaHandlerGroup;
        this.v2SchemaHandlerGroup = v2SchemaHandlerGroup;
    }
}

