/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.loader;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateLoaderException;
import com.netflix.spinnaker.orca.pipelinetemplate.loader.TemplateSchemeLoader;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileTemplateSchemeLoader
implements TemplateSchemeLoader {
    private final ObjectMapper jsonObjectMapper;
    private final ObjectMapper yamlObjectMapper;

    @Autowired
    public FileTemplateSchemeLoader(ObjectMapper pipelineTemplateObjectMapper) {
        this.jsonObjectMapper = pipelineTemplateObjectMapper;
        this.yamlObjectMapper = new ObjectMapper((JsonFactory)new YAMLFactory()).setConfig(this.jsonObjectMapper.getSerializationConfig()).setConfig(this.jsonObjectMapper.getDeserializationConfig());
    }

    @Override
    public boolean supports(URI uri) {
        String scheme = uri.getScheme();
        return scheme.equalsIgnoreCase("file") && (this.isJson(uri) || this.isYaml(uri));
    }

    @Override
    public PipelineTemplate load(URI uri) {
        File templateFile = new File(uri);
        if (!templateFile.exists()) {
            throw new TemplateLoaderException(new FileNotFoundException(uri.toString()));
        }
        try {
            ObjectMapper objectMapper = this.isJson(uri) ? this.jsonObjectMapper : this.yamlObjectMapper;
            return (PipelineTemplate)objectMapper.readValue(templateFile, PipelineTemplate.class);
        }
        catch (IOException e) {
            throw new TemplateLoaderException(e);
        }
    }
}

