/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.loader;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateLoaderException;
import com.netflix.spinnaker.orca.pipelinetemplate.loader.TemplateSchemeLoader;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Front50SchemeLoader
implements TemplateSchemeLoader {
    private final Front50Service front50Service;
    private final ObjectMapper objectMapper;

    @Autowired
    public Front50SchemeLoader(Optional<Front50Service> front50Service, ObjectMapper pipelineTemplateObjectMapper) {
        this.front50Service = front50Service.orElse(null);
        this.objectMapper = pipelineTemplateObjectMapper;
    }

    @Override
    public boolean supports(URI uri) {
        String scheme = uri.getScheme();
        return scheme.equalsIgnoreCase("spinnaker");
    }

    @Override
    public PipelineTemplate load(URI uri) {
        if (this.front50Service == null) {
            throw new TemplateLoaderException("Cannot load templates without front50 enabled. Set 'front50.enabled: true' in your orca config.");
        }
        String id = uri.getRawAuthority();
        try {
            Map pipelineTemplate = (Map)AuthenticatedRequest.allowAnonymous(() -> this.front50Service.getPipelineTemplate(id));
            return (PipelineTemplate)this.objectMapper.convertValue((Object)pipelineTemplate, PipelineTemplate.class);
        }
        catch (Exception e) {
            throw new TemplateLoaderException(e);
        }
    }
}

