/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.loader;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateLoaderException;
import com.netflix.spinnaker.orca.pipelinetemplate.loader.TemplateSchemeLoader;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpTemplateSchemeLoader
implements TemplateSchemeLoader {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper jsonObjectMapper;
    private final ObjectMapper yamlObjectMapper;
    private final OkHttpClient okHttpClient;

    @Autowired
    public HttpTemplateSchemeLoader(ObjectMapper pipelineTemplateObjectMapper) {
        this.jsonObjectMapper = pipelineTemplateObjectMapper;
        this.yamlObjectMapper = new ObjectMapper((JsonFactory)new YAMLFactory()).setConfig(this.jsonObjectMapper.getSerializationConfig()).setConfig(this.jsonObjectMapper.getDeserializationConfig());
        this.okHttpClient = new OkHttpClient();
    }

    @Override
    public boolean supports(URI uri) {
        String scheme = uri.getScheme();
        return scheme.equalsIgnoreCase("http") || scheme.equalsIgnoreCase("https");
    }

    @Override
    public PipelineTemplate load(URI uri) {
        PipelineTemplate pipelineTemplate;
        block9: {
            this.log.debug("Resolving pipeline template: {}", (Object)uri.toString());
            Request request = new Request.Builder().url(this.convertToUrl(uri)).build();
            Response response = this.okHttpClient.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new FileNotFoundException(String.format("Received unsuccessful status code from template (code: %s, url: %s)", response.code(), uri.toString()));
                }
                ResponseBody body = Optional.ofNullable(response.body()).orElseThrow(() -> new TemplateLoaderException("Endpoint returned an empty body"));
                String strBody = body.string();
                this.log.debug("Loaded Template ({}):\n{}", (Object)uri, (Object)strBody);
                ObjectMapper objectMapper = this.isJson(uri) ? this.jsonObjectMapper : this.yamlObjectMapper;
                pipelineTemplate = (PipelineTemplate)objectMapper.readValue(strBody, PipelineTemplate.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new TemplateLoaderException(e);
                }
            }
            response.close();
        }
        return pipelineTemplate;
    }

    private URL convertToUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new TemplateLoaderException(e);
        }
    }
}

