/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.loader;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateLoaderException;
import com.netflix.spinnaker.orca.pipelinetemplate.loader.TemplateSchemeLoader;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class ResourceSchemeLoader
implements TemplateSchemeLoader {
    private final String rootPath;
    private final ObjectMapper jsonObjectMapper;
    private final ObjectMapper yamlObjectMapper;

    public ResourceSchemeLoader(String rootPath, ObjectMapper objectMapper) {
        this.rootPath = rootPath;
        this.jsonObjectMapper = objectMapper;
        this.yamlObjectMapper = new ObjectMapper((JsonFactory)new YAMLFactory()).setConfig(this.jsonObjectMapper.getSerializationConfig()).setConfig(this.jsonObjectMapper.getDeserializationConfig());
    }

    @Override
    public boolean supports(URI uri) {
        URI u = this.convertToResourcePath(uri);
        String scheme = u.getScheme();
        return scheme.equalsIgnoreCase("file") && (this.isJson(u) || this.isYaml(u));
    }

    @Override
    public PipelineTemplate load(URI uri) {
        URI u = this.convertToResourcePath(uri);
        File templateFile = new File(u);
        if (!templateFile.exists()) {
            throw new TemplateLoaderException(new FileNotFoundException(u.toString()));
        }
        try {
            ObjectMapper objectMapper = this.isJson(u) ? this.jsonObjectMapper : this.yamlObjectMapper;
            return (PipelineTemplate)objectMapper.readValue(templateFile, PipelineTemplate.class);
        }
        catch (IOException e) {
            throw new TemplateLoaderException(e);
        }
    }

    private URI convertToResourcePath(URI uri) {
        try {
            return this.getClass().getResource(this.rootPath + "/" + uri.toString()).toURI();
        }
        catch (URISyntaxException e) {
            throw new TemplateLoaderException(e);
        }
    }
}

