/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.loader;

import com.netflix.spinnaker.orca.pipelinetemplate.exceptions.TemplateLoaderException;
import com.netflix.spinnaker.orca.pipelinetemplate.loader.TemplateSchemeLoader;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.TemplateConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TemplateLoader {
    private Collection<TemplateSchemeLoader> schemeLoaders;

    @Autowired
    public TemplateLoader(Collection<TemplateSchemeLoader> schemeLoaders) {
        this.schemeLoaders = schemeLoaders;
    }

    public List<PipelineTemplate> load(TemplateConfiguration.TemplateSource template) {
        PipelineTemplate pipelineTemplate = this.load(template.getSource());
        return this.load(pipelineTemplate);
    }

    public List<PipelineTemplate> load(PipelineTemplate pipelineTemplate) {
        ArrayList<PipelineTemplate> pipelineTemplates = new ArrayList<PipelineTemplate>();
        pipelineTemplates.add(0, pipelineTemplate);
        HashSet<String> seenTemplateSources = new HashSet<String>();
        while (pipelineTemplate.getSource() != null) {
            seenTemplateSources.add(pipelineTemplate.getSource());
            pipelineTemplate = this.load(pipelineTemplate.getSource());
            pipelineTemplates.add(0, pipelineTemplate);
            if (!seenTemplateSources.contains(pipelineTemplate.getSource())) continue;
            throw new TemplateLoaderException(String.format("Illegal cycle detected loading pipeline template '%s'", pipelineTemplate.getSource()));
        }
        return pipelineTemplates;
    }

    private PipelineTemplate load(String source) {
        URI uri;
        try {
            uri = new URI(source);
        }
        catch (URISyntaxException e) {
            throw new TemplateLoaderException(String.format("Invalid URI '%s'", source), e);
        }
        TemplateSchemeLoader schemeLoader = this.schemeLoaders.stream().filter(l -> l.supports(uri)).findFirst().orElseThrow(() -> new TemplateLoaderException(String.format("No TemplateSchemeLoader found for '%s'", uri.getScheme())));
        return schemeLoader.load(uri);
    }
}

