/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.loader.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import com.netflix.spinnaker.orca.clouddriver.OortService;
import com.netflix.spinnaker.orca.pipelinetemplate.v2schema.model.V2PipelineTemplate;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import retrofit.client.Response;

@Component
public class V2TemplateLoader {
    private OortService oortService;
    private ObjectMapper objectMapper;

    @Autowired
    public V2TemplateLoader(OortService oortService, ObjectMapper objectMapper) {
        this.oortService = oortService;
        this.objectMapper = objectMapper;
    }

    public V2PipelineTemplate load(Artifact template) {
        Response templateContent = (Response)AuthenticatedRequest.allowAnonymous(() -> this.oortService.fetchArtifact(template));
        try {
            return (V2PipelineTemplate)this.objectMapper.readValue(templateContent.getBody().in(), V2PipelineTemplate.class);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Error resolving pipeline template: " + template, ioe);
        }
    }
}

