/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.pipeline;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.SyntheticStageOwner;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageDefinitionBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.StageGraphBuilder;
import com.netflix.spinnaker.orca.api.pipeline.graph.TaskNode;
import com.netflix.spinnaker.orca.api.pipeline.models.PipelineExecution;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.front50.pipeline.UpdatePipelineStage;
import com.netflix.spinnaker.orca.pipeline.StageExecutionFactory;
import com.netflix.spinnaker.orca.pipeline.model.StageExecutionImpl;
import com.netflix.spinnaker.orca.pipelinetemplate.tasks.PlanTemplateDependentsTask;
import com.netflix.spinnaker.orca.pipelinetemplate.tasks.UpdatePipelineTemplateTask;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdatePipelineTemplateStage
implements StageDefinitionBuilder {
    @Autowired(required=false)
    private Front50Service front50Service;
    @Autowired
    private ObjectMapper pipelineTemplateObjectMapper;
    @Autowired(required=false)
    private UpdatePipelineStage updatePipelineStage;

    public void taskGraph(@Nonnull StageExecution stage, @Nonnull TaskNode.Builder builder) {
        if (!Boolean.valueOf(stage.getContext().getOrDefault("skipPlanDependents", "false").toString()).booleanValue()) {
            builder.withTask("planDependentPipelines", PlanTemplateDependentsTask.class);
        }
        builder.withTask("updatePipelineTemplate", UpdatePipelineTemplateTask.class);
    }

    public void afterStages(@Nonnull StageExecution stage, @Nonnull StageGraphBuilder graph) {
        if (this.front50Service == null) {
            return;
        }
        if (!stage.getContext().containsKey("pipelineTemplate")) {
            throw new IllegalArgumentException("Missing required task parameter (pipelineTemplate)");
        }
        if (!(stage.getContext().get("pipelineTemplate") instanceof String)) {
            throw new IllegalArgumentException("'pipelineTemplate' context key must be a base64-encoded string: Ensure you're on the most recent version of gate");
        }
        PipelineTemplate pipelineTemplate = (PipelineTemplate)((StageExecutionImpl)stage).decodeBase64("/pipelineTemplate", PipelineTemplate.class, this.pipelineTemplateObjectMapper);
        List dependentPipelines = this.front50Service.getPipelineTemplateDependents(pipelineTemplate.getId(), true);
        dependentPipelines.stream().map(pipeline -> this.configureSavePipelineStage(stage, (Map<String, Object>)pipeline)).forEach(arg_0 -> ((StageGraphBuilder)graph).append(arg_0));
    }

    private StageExecution configureSavePipelineStage(StageExecution stage, Map<String, Object> pipeline) {
        HashMap<String, String> context = new HashMap<String, String>();
        try {
            context.put("pipeline", Base64.getEncoder().encodeToString(this.pipelineTemplateObjectMapper.writeValueAsBytes(pipeline)));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(String.format("Failed converting pipeline to JSON: %s", pipeline.get("id")), e);
        }
        return StageExecutionFactory.newStage((PipelineExecution)stage.getExecution(), (String)this.updatePipelineStage.getType(), (String)"updateDependentPipeline", context, (StageExecution)stage, (SyntheticStageOwner)SyntheticStageOwner.STAGE_AFTER);
    }
}

