/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.pipeline.model.StageExecutionImpl;
import com.netflix.spinnaker.orca.pipelinetemplate.tasks.SavePipelineTemplateTask;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import retrofit.client.Response;

@Component
public class CreatePipelineTemplateTask
implements RetryableTask,
SavePipelineTemplateTask {
    @Autowired(required=false)
    private Front50Service front50Service;
    @Autowired
    private ObjectMapper pipelineTemplateObjectMapper;

    public TaskResult execute(StageExecution stage) {
        if (this.front50Service == null) {
            throw new UnsupportedOperationException("Front50 is not enabled, no way to save pipeline templates. Fix this by setting front50.enabled: true");
        }
        if (!stage.getContext().containsKey("pipelineTemplate")) {
            throw new IllegalArgumentException("Missing required task parameter (pipelineTemplate)");
        }
        if (!(stage.getContext().get("pipelineTemplate") instanceof String)) {
            throw new IllegalArgumentException("'pipelineTemplate' context key must be a base64-encoded string: Ensure you're on the most recent version of gate");
        }
        PipelineTemplate pipelineTemplate = (PipelineTemplate)((StageExecutionImpl)stage).decodeBase64("/pipelineTemplate", PipelineTemplate.class, this.pipelineTemplateObjectMapper);
        this.validate(pipelineTemplate);
        Response response = this.front50Service.savePipelineTemplate((Map)((StageExecutionImpl)stage).decodeBase64("/pipelineTemplate", Map.class, this.pipelineTemplateObjectMapper));
        HashMap<String, String> outputs = new HashMap<String, String>();
        outputs.put("notification.type", "createpipelinetemplate");
        outputs.put("pipelineTemplate.id", pipelineTemplate.getId());
        if (response.getStatus() == HttpStatus.OK.value()) {
            return TaskResult.builder((ExecutionStatus)ExecutionStatus.SUCCEEDED).context(outputs).build();
        }
        return TaskResult.builder((ExecutionStatus)ExecutionStatus.TERMINAL).context(outputs).build();
    }

    public long getBackoffPeriod() {
        return 15000L;
    }

    public long getTimeout() {
        return TimeUnit.MINUTES.toMillis(1L);
    }
}

