/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.tasks;

import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import retrofit.client.Response;

@Component
public class DeletePipelineTemplateTask
implements RetryableTask {
    @Autowired(required=false)
    private Front50Service front50Service;

    public TaskResult execute(StageExecution stage) {
        if (this.front50Service == null) {
            throw new UnsupportedOperationException("Front50 is not enabled, no way to delete pipeline. Fix this by setting front50.enabled: true");
        }
        if (!stage.getContext().containsKey("pipelineTemplateId")) {
            throw new IllegalArgumentException("Missing required task parameter (pipelineTemplateId)");
        }
        String templateId = (String)stage.getContext().get("pipelineTemplateId");
        Response response = this.front50Service.deletePipelineTemplate(templateId);
        HashMap<String, String> outputs = new HashMap<String, String>();
        outputs.put("notification.type", "deletepipelinetemplate");
        outputs.put("pipeline.id", templateId);
        return TaskResult.builder((ExecutionStatus)(response.getStatus() == HttpStatus.OK.value() ? ExecutionStatus.SUCCEEDED : ExecutionStatus.TERMINAL)).context(outputs).build();
    }

    public long getBackoffPeriod() {
        return 15000L;
    }

    public long getTimeout() {
        return TimeUnit.MINUTES.toMillis(1L);
    }
}

