/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.orca.pipelinetemplate.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.orca.api.pipeline.ExecutionPreprocessor;
import com.netflix.spinnaker.orca.api.pipeline.RetryableTask;
import com.netflix.spinnaker.orca.api.pipeline.TaskResult;
import com.netflix.spinnaker.orca.api.pipeline.models.ExecutionStatus;
import com.netflix.spinnaker.orca.api.pipeline.models.StageExecution;
import com.netflix.spinnaker.orca.front50.Front50Service;
import com.netflix.spinnaker.orca.pipeline.model.StageExecutionImpl;
import com.netflix.spinnaker.orca.pipelinetemplate.v1schema.model.PipelineTemplate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlanTemplateDependentsTask
implements RetryableTask {
    @Autowired(required=false)
    private Front50Service front50Service;
    @Autowired
    private ObjectMapper pipelineTemplateObjectMapper;
    @Autowired
    private ExecutionPreprocessor pipelineTemplatePreprocessor;

    @Nonnull
    public TaskResult execute(@Nonnull StageExecution stage) {
        if (this.front50Service == null) {
            throw new UnsupportedOperationException("Front50 is not enabled. Fix this by setting front50.enabled: true");
        }
        if (!stage.getContext().containsKey("pipelineTemplate")) {
            throw new IllegalArgumentException("Missing required task parameter (pipelineTemplate)");
        }
        if (!(stage.getContext().get("pipelineTemplate") instanceof String)) {
            throw new IllegalArgumentException("'pipelineTemplate' context key must be a base64-encoded string: Ensure you're on the most recent version of gate");
        }
        PipelineTemplate pipelineTemplate = (PipelineTemplate)((StageExecutionImpl)stage).decodeBase64("/pipelineTemplate", PipelineTemplate.class, this.pipelineTemplateObjectMapper);
        List dependentPipelines = this.front50Service.getPipelineTemplateDependents(pipelineTemplate.getId(), false);
        HashMap errorResponses = new HashMap();
        for (Map dependentPipeline : dependentPipelines) {
            HashMap<String, Object> request = new HashMap<String, Object>();
            request.put("type", "templatedPipeline");
            request.put("trigger", new HashMap());
            request.put("config", dependentPipeline.get("config"));
            request.put("template", pipelineTemplate);
            request.put("plan", true);
            Map response = this.pipelineTemplatePreprocessor.process(request);
            if (!response.containsKey("errors")) continue;
            errorResponses.put((String)dependentPipeline.get("id"), response.get("errors"));
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("notification.type", "plantemplatedependents");
        context.put("pipelineTemplate.id", pipelineTemplate.getId());
        context.put("pipelineTemplate.allDependentPipelines", dependentPipelines.stream().map(it -> it.get("id")).collect(Collectors.toList()));
        if (!errorResponses.isEmpty()) {
            context.put("pipelineTemplate.dependentErrors", errorResponses);
        }
        return TaskResult.builder((ExecutionStatus)(errorResponses.isEmpty() ? ExecutionStatus.SUCCEEDED : ExecutionStatus.TERMINAL)).context(context).outputs(Collections.emptyMap()).build();
    }

    public long getBackoffPeriod() {
        return 15000L;
    }

    public long getTimeout() {
        return TimeUnit.MINUTES.toMillis(10L);
    }
}

